/****************************************************************************
  CG ROM from X Millennium
  http://www.turboz.to/
***************************************************************************/

// adr[10:3] character name
// adr[2:0] line of character
module x1_cg8(I_CLK, I_ADDR, O_DATA);

input I_CLK;
input [10:0] I_ADDR;
output [7:0] O_DATA;
reg [7:0] O_DATA;

function [7:0] cg8_rom;
input [10:0] adr;
begin
  case (adr)
// 00
  11'h000:cg8_rom = 8'b01110000;
  11'h001:cg8_rom = 8'b00000000;
  11'h002:cg8_rom = 8'b00011100;
  11'h003:cg8_rom = 8'b00000010;
  11'h004:cg8_rom = 8'b00011010;
  11'h005:cg8_rom = 8'b00010110;
  11'h006:cg8_rom = 8'b00011110;
  11'h007:cg8_rom = 8'b00000000;
// 01
  11'h008:cg8_rom = 8'b01110000;
  11'h009:cg8_rom = 8'b00000000;
  11'h00A:cg8_rom = 8'b00001100;
  11'h00B:cg8_rom = 8'b00010010;
  11'h00C:cg8_rom = 8'b00010010;
  11'h00D:cg8_rom = 8'b00011110;
  11'h00E:cg8_rom = 8'b00010010;
  11'h00F:cg8_rom = 8'b00000000;
// 02
  11'h010:cg8_rom = 8'b01110000;
  11'h011:cg8_rom = 8'b00000000;
  11'h012:cg8_rom = 8'b00011100;
  11'h013:cg8_rom = 8'b00010010;
  11'h014:cg8_rom = 8'b00011100;
  11'h015:cg8_rom = 8'b00010010;
  11'h016:cg8_rom = 8'b00011100;
  11'h017:cg8_rom = 8'b00000000;
// 03
  11'h018:cg8_rom = 8'b01110000;
  11'h019:cg8_rom = 8'b00000000;
  11'h01A:cg8_rom = 8'b00001110;
  11'h01B:cg8_rom = 8'b00010000;
  11'h01C:cg8_rom = 8'b00010000;
  11'h01D:cg8_rom = 8'b00010000;
  11'h01E:cg8_rom = 8'b00001110;
  11'h01F:cg8_rom = 8'b00000000;
// 04
  11'h020:cg8_rom = 8'b01110000;
  11'h021:cg8_rom = 8'b00000000;
  11'h022:cg8_rom = 8'b00011100;
  11'h023:cg8_rom = 8'b00010010;
  11'h024:cg8_rom = 8'b00010010;
  11'h025:cg8_rom = 8'b00010010;
  11'h026:cg8_rom = 8'b00011100;
  11'h027:cg8_rom = 8'b00000000;
// 05
  11'h028:cg8_rom = 8'b01110000;
  11'h029:cg8_rom = 8'b00000000;
  11'h02A:cg8_rom = 8'b00011110;
  11'h02B:cg8_rom = 8'b00010000;
  11'h02C:cg8_rom = 8'b00011100;
  11'h02D:cg8_rom = 8'b00010000;
  11'h02E:cg8_rom = 8'b00011110;
  11'h02F:cg8_rom = 8'b00000000;
// 06
  11'h030:cg8_rom = 8'b01110000;
  11'h031:cg8_rom = 8'b00000000;
  11'h032:cg8_rom = 8'b00011110;
  11'h033:cg8_rom = 8'b00010000;
  11'h034:cg8_rom = 8'b00010000;
  11'h035:cg8_rom = 8'b00011100;
  11'h036:cg8_rom = 8'b00010000;
  11'h037:cg8_rom = 8'b00000000;
// 07
  11'h038:cg8_rom = 8'b01110000;
  11'h039:cg8_rom = 8'b00000000;
  11'h03A:cg8_rom = 8'b00001110;
  11'h03B:cg8_rom = 8'b00010000;
  11'h03C:cg8_rom = 8'b00010110;
  11'h03D:cg8_rom = 8'b00010010;
  11'h03E:cg8_rom = 8'b00001110;
  11'h03F:cg8_rom = 8'b00000000;
// 08
  11'h040:cg8_rom = 8'b01110000;
  11'h041:cg8_rom = 8'b00000000;
  11'h042:cg8_rom = 8'b00010010;
  11'h043:cg8_rom = 8'b00010010;
  11'h044:cg8_rom = 8'b00011110;
  11'h045:cg8_rom = 8'b00010010;
  11'h046:cg8_rom = 8'b00010010;
  11'h047:cg8_rom = 8'b00000000;
// 09
  11'h048:cg8_rom = 8'b01110000;
  11'h049:cg8_rom = 8'b00000000;
  11'h04A:cg8_rom = 8'b00001110;
  11'h04B:cg8_rom = 8'b00000100;
  11'h04C:cg8_rom = 8'b00000100;
  11'h04D:cg8_rom = 8'b00000100;
  11'h04E:cg8_rom = 8'b00001110;
  11'h04F:cg8_rom = 8'b00000000;
// 0A
  11'h050:cg8_rom = 8'b01110000;
  11'h051:cg8_rom = 8'b00000000;
  11'h052:cg8_rom = 8'b00000110;
  11'h053:cg8_rom = 8'b00000010;
  11'h054:cg8_rom = 8'b00000010;
  11'h055:cg8_rom = 8'b00001010;
  11'h056:cg8_rom = 8'b00001110;
  11'h057:cg8_rom = 8'b00000000;
// 0B
  11'h058:cg8_rom = 8'b01110000;
  11'h059:cg8_rom = 8'b00000000;
  11'h05A:cg8_rom = 8'b00010010;
  11'h05B:cg8_rom = 8'b00010100;
  11'h05C:cg8_rom = 8'b00011000;
  11'h05D:cg8_rom = 8'b00010100;
  11'h05E:cg8_rom = 8'b00010010;
  11'h05F:cg8_rom = 8'b00000000;
// 0C
  11'h060:cg8_rom = 8'b01110000;
  11'h061:cg8_rom = 8'b00000000;
  11'h062:cg8_rom = 8'b00010000;
  11'h063:cg8_rom = 8'b00010000;
  11'h064:cg8_rom = 8'b00010000;
  11'h065:cg8_rom = 8'b00010000;
  11'h066:cg8_rom = 8'b00011110;
  11'h067:cg8_rom = 8'b00000000;
// 0D
  11'h068:cg8_rom = 8'b01110000;
  11'h069:cg8_rom = 8'b00000000;
  11'h06A:cg8_rom = 8'b00010010;
  11'h06B:cg8_rom = 8'b00011110;
  11'h06C:cg8_rom = 8'b00010010;
  11'h06D:cg8_rom = 8'b00010010;
  11'h06E:cg8_rom = 8'b00010010;
  11'h06F:cg8_rom = 8'b00000000;
// 0E
  11'h070:cg8_rom = 8'b01110000;
  11'h071:cg8_rom = 8'b00000000;
  11'h072:cg8_rom = 8'b00010010;
  11'h073:cg8_rom = 8'b00011010;
  11'h074:cg8_rom = 8'b00010110;
  11'h075:cg8_rom = 8'b00010010;
  11'h076:cg8_rom = 8'b00010010;
  11'h077:cg8_rom = 8'b00000000;
// 0F
  11'h078:cg8_rom = 8'b01110000;
  11'h079:cg8_rom = 8'b00000000;
  11'h07A:cg8_rom = 8'b00001100;
  11'h07B:cg8_rom = 8'b00010010;
  11'h07C:cg8_rom = 8'b00010010;
  11'h07D:cg8_rom = 8'b00010010;
  11'h07E:cg8_rom = 8'b00001100;
  11'h07F:cg8_rom = 8'b00000000;
// 10
  11'h080:cg8_rom = 8'b01110000;
  11'h081:cg8_rom = 8'b00000000;
  11'h082:cg8_rom = 8'b00011110;
  11'h083:cg8_rom = 8'b00010010;
  11'h084:cg8_rom = 8'b00011110;
  11'h085:cg8_rom = 8'b00010000;
  11'h086:cg8_rom = 8'b00010000;
  11'h087:cg8_rom = 8'b00000000;
// 11
  11'h088:cg8_rom = 8'b01110000;
  11'h089:cg8_rom = 8'b00000000;
  11'h08A:cg8_rom = 8'b00001100;
  11'h08B:cg8_rom = 8'b00010010;
  11'h08C:cg8_rom = 8'b00010010;
  11'h08D:cg8_rom = 8'b00010110;
  11'h08E:cg8_rom = 8'b00001110;
  11'h08F:cg8_rom = 8'b00000000;
// 12
  11'h090:cg8_rom = 8'b01110000;
  11'h091:cg8_rom = 8'b00000000;
  11'h092:cg8_rom = 8'b00011100;
  11'h093:cg8_rom = 8'b00010010;
  11'h094:cg8_rom = 8'b00011110;
  11'h095:cg8_rom = 8'b00010100;
  11'h096:cg8_rom = 8'b00010010;
  11'h097:cg8_rom = 8'b00000000;
// 13
  11'h098:cg8_rom = 8'b01110000;
  11'h099:cg8_rom = 8'b00000000;
  11'h09A:cg8_rom = 8'b00001100;
  11'h09B:cg8_rom = 8'b00010000;
  11'h09C:cg8_rom = 8'b00001100;
  11'h09D:cg8_rom = 8'b00000010;
  11'h09E:cg8_rom = 8'b00011100;
  11'h09F:cg8_rom = 8'b00000000;
// 14
  11'h0A0:cg8_rom = 8'b01110000;
  11'h0A1:cg8_rom = 8'b00000000;
  11'h0A2:cg8_rom = 8'b00001110;
  11'h0A3:cg8_rom = 8'b00000100;
  11'h0A4:cg8_rom = 8'b00000100;
  11'h0A5:cg8_rom = 8'b00000100;
  11'h0A6:cg8_rom = 8'b00000100;
  11'h0A7:cg8_rom = 8'b00000000;
// 15
  11'h0A8:cg8_rom = 8'b01110000;
  11'h0A9:cg8_rom = 8'b00000000;
  11'h0AA:cg8_rom = 8'b00010010;
  11'h0AB:cg8_rom = 8'b00010010;
  11'h0AC:cg8_rom = 8'b00010010;
  11'h0AD:cg8_rom = 8'b00010010;
  11'h0AE:cg8_rom = 8'b00011110;
  11'h0AF:cg8_rom = 8'b00000000;
// 16
  11'h0B0:cg8_rom = 8'b01110000;
  11'h0B1:cg8_rom = 8'b00000000;
  11'h0B2:cg8_rom = 8'b00010010;
  11'h0B3:cg8_rom = 8'b00010010;
  11'h0B4:cg8_rom = 8'b00010010;
  11'h0B5:cg8_rom = 8'b00010010;
  11'h0B6:cg8_rom = 8'b00001100;
  11'h0B7:cg8_rom = 8'b00000000;
// 17
  11'h0B8:cg8_rom = 8'b01110000;
  11'h0B9:cg8_rom = 8'b00000000;
  11'h0BA:cg8_rom = 8'b00010010;
  11'h0BB:cg8_rom = 8'b00010010;
  11'h0BC:cg8_rom = 8'b00010010;
  11'h0BD:cg8_rom = 8'b00011110;
  11'h0BE:cg8_rom = 8'b00010010;
  11'h0BF:cg8_rom = 8'b00000000;
// 18
  11'h0C0:cg8_rom = 8'b01110000;
  11'h0C1:cg8_rom = 8'b00000000;
  11'h0C2:cg8_rom = 8'b00010010;
  11'h0C3:cg8_rom = 8'b00010010;
  11'h0C4:cg8_rom = 8'b00001100;
  11'h0C5:cg8_rom = 8'b00010010;
  11'h0C6:cg8_rom = 8'b00010010;
  11'h0C7:cg8_rom = 8'b00000000;
// 19
  11'h0C8:cg8_rom = 8'b01110000;
  11'h0C9:cg8_rom = 8'b00000000;
  11'h0CA:cg8_rom = 8'b00001010;
  11'h0CB:cg8_rom = 8'b00001010;
  11'h0CC:cg8_rom = 8'b00001110;
  11'h0CD:cg8_rom = 8'b00000100;
  11'h0CE:cg8_rom = 8'b00000100;
  11'h0CF:cg8_rom = 8'b00000000;
// 1A
  11'h0D0:cg8_rom = 8'b01110000;
  11'h0D1:cg8_rom = 8'b00000000;
  11'h0D2:cg8_rom = 8'b00011100;
  11'h0D3:cg8_rom = 8'b00000010;
  11'h0D4:cg8_rom = 8'b00001100;
  11'h0D5:cg8_rom = 8'b00010000;
  11'h0D6:cg8_rom = 8'b00011110;
  11'h0D7:cg8_rom = 8'b00000000;
// 1B
  11'h0D8:cg8_rom = 8'b01110000;
  11'h0D9:cg8_rom = 8'b01000000;
  11'h0DA:cg8_rom = 8'b01110000;
  11'h0DB:cg8_rom = 8'b01000000;
  11'h0DC:cg8_rom = 8'b01111110;
  11'h0DD:cg8_rom = 8'b00010000;
  11'h0DE:cg8_rom = 8'b00010000;
  11'h0DF:cg8_rom = 8'b00001110;
// 1C
  11'h0E0:cg8_rom = 8'b00000000;
  11'h0E1:cg8_rom = 8'b00001000;
  11'h0E2:cg8_rom = 8'b00000100;
  11'h0E3:cg8_rom = 8'b01111110;
  11'h0E4:cg8_rom = 8'b00000100;
  11'h0E5:cg8_rom = 8'b00001000;
  11'h0E6:cg8_rom = 8'b00000000;
  11'h0E7:cg8_rom = 8'b00000000;
// 1D
  11'h0E8:cg8_rom = 8'b00000000;
  11'h0E9:cg8_rom = 8'b00010000;
  11'h0EA:cg8_rom = 8'b00100000;
  11'h0EB:cg8_rom = 8'b01111110;
  11'h0EC:cg8_rom = 8'b00100000;
  11'h0ED:cg8_rom = 8'b00010000;
  11'h0EE:cg8_rom = 8'b00000000;
  11'h0EF:cg8_rom = 8'b00000000;
// 1E
  11'h0F0:cg8_rom = 8'b00000000;
  11'h0F1:cg8_rom = 8'b00001000;
  11'h0F2:cg8_rom = 8'b00011100;
  11'h0F3:cg8_rom = 8'b00101010;
  11'h0F4:cg8_rom = 8'b00001000;
  11'h0F5:cg8_rom = 8'b00001000;
  11'h0F6:cg8_rom = 8'b00001000;
  11'h0F7:cg8_rom = 8'b00000000;
// 1F
  11'h0F8:cg8_rom = 8'b00000000;
  11'h0F9:cg8_rom = 8'b00001000;
  11'h0FA:cg8_rom = 8'b00001000;
  11'h0FB:cg8_rom = 8'b00001000;
  11'h0FC:cg8_rom = 8'b00101010;
  11'h0FD:cg8_rom = 8'b00011100;
  11'h0FE:cg8_rom = 8'b00001000;
  11'h0FF:cg8_rom = 8'b00000000;
// 20
  11'h100:cg8_rom = 8'b00000000;
  11'h101:cg8_rom = 8'b00000000;
  11'h102:cg8_rom = 8'b00000000;
  11'h103:cg8_rom = 8'b00000000;
  11'h104:cg8_rom = 8'b00000000;
  11'h105:cg8_rom = 8'b00000000;
  11'h106:cg8_rom = 8'b00000000;
  11'h107:cg8_rom = 8'b00000000;
// 21
  11'h108:cg8_rom = 8'b00001000;
  11'h109:cg8_rom = 8'b00001000;
  11'h10A:cg8_rom = 8'b00001000;
  11'h10B:cg8_rom = 8'b00001000;
  11'h10C:cg8_rom = 8'b00001000;
  11'h10D:cg8_rom = 8'b00000000;
  11'h10E:cg8_rom = 8'b00001000;
  11'h10F:cg8_rom = 8'b00000000;
// 22
  11'h110:cg8_rom = 8'b00010100;
  11'h111:cg8_rom = 8'b00010100;
  11'h112:cg8_rom = 8'b00000000;
  11'h113:cg8_rom = 8'b00000000;
  11'h114:cg8_rom = 8'b00000000;
  11'h115:cg8_rom = 8'b00000000;
  11'h116:cg8_rom = 8'b00000000;
  11'h117:cg8_rom = 8'b00000000;
// 23
  11'h118:cg8_rom = 8'b00100100;
  11'h119:cg8_rom = 8'b00100100;
  11'h11A:cg8_rom = 8'b01111110;
  11'h11B:cg8_rom = 8'b00100100;
  11'h11C:cg8_rom = 8'b00100100;
  11'h11D:cg8_rom = 8'b01111110;
  11'h11E:cg8_rom = 8'b00100100;
  11'h11F:cg8_rom = 8'b00000000;
// 24
  11'h120:cg8_rom = 8'b00001000;
  11'h121:cg8_rom = 8'b00011100;
  11'h122:cg8_rom = 8'b00101000;
  11'h123:cg8_rom = 8'b00011100;
  11'h124:cg8_rom = 8'b00001010;
  11'h125:cg8_rom = 8'b00011100;
  11'h126:cg8_rom = 8'b00001000;
  11'h127:cg8_rom = 8'b00000000;
// 25
  11'h128:cg8_rom = 8'b00000000;
  11'h129:cg8_rom = 8'b01100010;
  11'h12A:cg8_rom = 8'b01100100;
  11'h12B:cg8_rom = 8'b00001000;
  11'h12C:cg8_rom = 8'b00010000;
  11'h12D:cg8_rom = 8'b00100110;
  11'h12E:cg8_rom = 8'b01000110;
  11'h12F:cg8_rom = 8'b00000000;
// 26
  11'h130:cg8_rom = 8'b00110000;
  11'h131:cg8_rom = 8'b01001000;
  11'h132:cg8_rom = 8'b01001000;
  11'h133:cg8_rom = 8'b00110000;
  11'h134:cg8_rom = 8'b01001010;
  11'h135:cg8_rom = 8'b01000100;
  11'h136:cg8_rom = 8'b00111010;
  11'h137:cg8_rom = 8'b00000000;
// 27
  11'h138:cg8_rom = 8'b00011000;
  11'h139:cg8_rom = 8'b00001000;
  11'h13A:cg8_rom = 8'b00010000;
  11'h13B:cg8_rom = 8'b00000000;
  11'h13C:cg8_rom = 8'b00000000;
  11'h13D:cg8_rom = 8'b00000000;
  11'h13E:cg8_rom = 8'b00000000;
  11'h13F:cg8_rom = 8'b00000000;
// 28
  11'h140:cg8_rom = 8'b00000100;
  11'h141:cg8_rom = 8'b00001000;
  11'h142:cg8_rom = 8'b00010000;
  11'h143:cg8_rom = 8'b00010000;
  11'h144:cg8_rom = 8'b00010000;
  11'h145:cg8_rom = 8'b00001000;
  11'h146:cg8_rom = 8'b00000100;
  11'h147:cg8_rom = 8'b00000000;
// 29
  11'h148:cg8_rom = 8'b00100000;
  11'h149:cg8_rom = 8'b00010000;
  11'h14A:cg8_rom = 8'b00001000;
  11'h14B:cg8_rom = 8'b00001000;
  11'h14C:cg8_rom = 8'b00001000;
  11'h14D:cg8_rom = 8'b00010000;
  11'h14E:cg8_rom = 8'b00100000;
  11'h14F:cg8_rom = 8'b00000000;
// 2A
  11'h150:cg8_rom = 8'b00000000;
  11'h151:cg8_rom = 8'b00010100;
  11'h152:cg8_rom = 8'b00001000;
  11'h153:cg8_rom = 8'b00111110;
  11'h154:cg8_rom = 8'b00001000;
  11'h155:cg8_rom = 8'b00010100;
  11'h156:cg8_rom = 8'b00000000;
  11'h157:cg8_rom = 8'b00000000;
// 2B
  11'h158:cg8_rom = 8'b00000000;
  11'h159:cg8_rom = 8'b00001000;
  11'h15A:cg8_rom = 8'b00001000;
  11'h15B:cg8_rom = 8'b00111110;
  11'h15C:cg8_rom = 8'b00001000;
  11'h15D:cg8_rom = 8'b00001000;
  11'h15E:cg8_rom = 8'b00000000;
  11'h15F:cg8_rom = 8'b00000000;
// 2C
  11'h160:cg8_rom = 8'b00000000;
  11'h161:cg8_rom = 8'b00000000;
  11'h162:cg8_rom = 8'b00000000;
  11'h163:cg8_rom = 8'b00000000;
  11'h164:cg8_rom = 8'b00000000;
  11'h165:cg8_rom = 8'b00011000;
  11'h166:cg8_rom = 8'b00001000;
  11'h167:cg8_rom = 8'b00010000;
// 2D
  11'h168:cg8_rom = 8'b00000000;
  11'h169:cg8_rom = 8'b00000000;
  11'h16A:cg8_rom = 8'b00000000;
  11'h16B:cg8_rom = 8'b00111110;
  11'h16C:cg8_rom = 8'b00000000;
  11'h16D:cg8_rom = 8'b00000000;
  11'h16E:cg8_rom = 8'b00000000;
  11'h16F:cg8_rom = 8'b00000000;
// 2E
  11'h170:cg8_rom = 8'b00000000;
  11'h171:cg8_rom = 8'b00000000;
  11'h172:cg8_rom = 8'b00000000;
  11'h173:cg8_rom = 8'b00000000;
  11'h174:cg8_rom = 8'b00000000;
  11'h175:cg8_rom = 8'b00011000;
  11'h176:cg8_rom = 8'b00011000;
  11'h177:cg8_rom = 8'b00000000;
// 2F
  11'h178:cg8_rom = 8'b00000000;
  11'h179:cg8_rom = 8'b00000010;
  11'h17A:cg8_rom = 8'b00000100;
  11'h17B:cg8_rom = 8'b00001000;
  11'h17C:cg8_rom = 8'b00010000;
  11'h17D:cg8_rom = 8'b00100000;
  11'h17E:cg8_rom = 8'b01000000;
  11'h17F:cg8_rom = 8'b00000000;
// 30
  11'h180:cg8_rom = 8'b00111100;
  11'h181:cg8_rom = 8'b01000010;
  11'h182:cg8_rom = 8'b01000110;
  11'h183:cg8_rom = 8'b01011010;
  11'h184:cg8_rom = 8'b01100010;
  11'h185:cg8_rom = 8'b01000010;
  11'h186:cg8_rom = 8'b00111100;
  11'h187:cg8_rom = 8'b00000000;
// 31
  11'h188:cg8_rom = 8'b00001000;
  11'h189:cg8_rom = 8'b00011000;
  11'h18A:cg8_rom = 8'b00001000;
  11'h18B:cg8_rom = 8'b00001000;
  11'h18C:cg8_rom = 8'b00001000;
  11'h18D:cg8_rom = 8'b00001000;
  11'h18E:cg8_rom = 8'b00011100;
  11'h18F:cg8_rom = 8'b00000000;
// 32
  11'h190:cg8_rom = 8'b00111100;
  11'h191:cg8_rom = 8'b01000010;
  11'h192:cg8_rom = 8'b00000010;
  11'h193:cg8_rom = 8'b00001100;
  11'h194:cg8_rom = 8'b00110000;
  11'h195:cg8_rom = 8'b01000000;
  11'h196:cg8_rom = 8'b01111110;
  11'h197:cg8_rom = 8'b00000000;
// 33
  11'h198:cg8_rom = 8'b01111110;
  11'h199:cg8_rom = 8'b00000100;
  11'h19A:cg8_rom = 8'b00001000;
  11'h19B:cg8_rom = 8'b00011100;
  11'h19C:cg8_rom = 8'b00000010;
  11'h19D:cg8_rom = 8'b01000010;
  11'h19E:cg8_rom = 8'b00111100;
  11'h19F:cg8_rom = 8'b00000000;
// 34
  11'h1A0:cg8_rom = 8'b00001100;
  11'h1A1:cg8_rom = 8'b00010100;
  11'h1A2:cg8_rom = 8'b00100100;
  11'h1A3:cg8_rom = 8'b01000100;
  11'h1A4:cg8_rom = 8'b01111110;
  11'h1A5:cg8_rom = 8'b00000100;
  11'h1A6:cg8_rom = 8'b00000100;
  11'h1A7:cg8_rom = 8'b00000000;
// 35
  11'h1A8:cg8_rom = 8'b01111110;
  11'h1A9:cg8_rom = 8'b01000000;
  11'h1AA:cg8_rom = 8'b01111100;
  11'h1AB:cg8_rom = 8'b00000010;
  11'h1AC:cg8_rom = 8'b00000010;
  11'h1AD:cg8_rom = 8'b01000010;
  11'h1AE:cg8_rom = 8'b00111100;
  11'h1AF:cg8_rom = 8'b00000000;
// 36
  11'h1B0:cg8_rom = 8'b00100000;
  11'h1B1:cg8_rom = 8'b00100000;
  11'h1B2:cg8_rom = 8'b00100000;
  11'h1B3:cg8_rom = 8'b00111100;
  11'h1B4:cg8_rom = 8'b01000010;
  11'h1B5:cg8_rom = 8'b01000010;
  11'h1B6:cg8_rom = 8'b00111100;
  11'h1B7:cg8_rom = 8'b00000000;
// 37
  11'h1B8:cg8_rom = 8'b01111110;
  11'h1B9:cg8_rom = 8'b01000010;
  11'h1BA:cg8_rom = 8'b00000100;
  11'h1BB:cg8_rom = 8'b00000100;
  11'h1BC:cg8_rom = 8'b00001000;
  11'h1BD:cg8_rom = 8'b00001000;
  11'h1BE:cg8_rom = 8'b00010000;
  11'h1BF:cg8_rom = 8'b00000000;
// 38
  11'h1C0:cg8_rom = 8'b00111100;
  11'h1C1:cg8_rom = 8'b01000010;
  11'h1C2:cg8_rom = 8'b01000010;
  11'h1C3:cg8_rom = 8'b00111100;
  11'h1C4:cg8_rom = 8'b01000010;
  11'h1C5:cg8_rom = 8'b01000010;
  11'h1C6:cg8_rom = 8'b00111100;
  11'h1C7:cg8_rom = 8'b00000000;
// 39
  11'h1C8:cg8_rom = 8'b00111100;
  11'h1C9:cg8_rom = 8'b01000010;
  11'h1CA:cg8_rom = 8'b01000010;
  11'h1CB:cg8_rom = 8'b00111100;
  11'h1CC:cg8_rom = 8'b00000100;
  11'h1CD:cg8_rom = 8'b00000100;
  11'h1CE:cg8_rom = 8'b00000100;
  11'h1CF:cg8_rom = 8'b00000000;
// 3A
  11'h1D0:cg8_rom = 8'b00000000;
  11'h1D1:cg8_rom = 8'b00000000;
  11'h1D2:cg8_rom = 8'b00011000;
  11'h1D3:cg8_rom = 8'b00011000;
  11'h1D4:cg8_rom = 8'b00000000;
  11'h1D5:cg8_rom = 8'b00011000;
  11'h1D6:cg8_rom = 8'b00011000;
  11'h1D7:cg8_rom = 8'b00000000;
// 3B
  11'h1D8:cg8_rom = 8'b00000000;
  11'h1D9:cg8_rom = 8'b00000000;
  11'h1DA:cg8_rom = 8'b00011000;
  11'h1DB:cg8_rom = 8'b00011000;
  11'h1DC:cg8_rom = 8'b00000000;
  11'h1DD:cg8_rom = 8'b00011000;
  11'h1DE:cg8_rom = 8'b00001000;
  11'h1DF:cg8_rom = 8'b00010000;
// 3C
  11'h1E0:cg8_rom = 8'b00000100;
  11'h1E1:cg8_rom = 8'b00001000;
  11'h1E2:cg8_rom = 8'b00010000;
  11'h1E3:cg8_rom = 8'b00100000;
  11'h1E4:cg8_rom = 8'b00010000;
  11'h1E5:cg8_rom = 8'b00001000;
  11'h1E6:cg8_rom = 8'b00000100;
  11'h1E7:cg8_rom = 8'b00000000;
// 3D
  11'h1E8:cg8_rom = 8'b00000000;
  11'h1E9:cg8_rom = 8'b00000000;
  11'h1EA:cg8_rom = 8'b01111110;
  11'h1EB:cg8_rom = 8'b00000000;
  11'h1EC:cg8_rom = 8'b01111110;
  11'h1ED:cg8_rom = 8'b00000000;
  11'h1EE:cg8_rom = 8'b00000000;
  11'h1EF:cg8_rom = 8'b00000000;
// 3E
  11'h1F0:cg8_rom = 8'b00100000;
  11'h1F1:cg8_rom = 8'b00010000;
  11'h1F2:cg8_rom = 8'b00001000;
  11'h1F3:cg8_rom = 8'b00000100;
  11'h1F4:cg8_rom = 8'b00001000;
  11'h1F5:cg8_rom = 8'b00010000;
  11'h1F6:cg8_rom = 8'b00100000;
  11'h1F7:cg8_rom = 8'b00000000;
// 3F
  11'h1F8:cg8_rom = 8'b00111100;
  11'h1F9:cg8_rom = 8'b01100110;
  11'h1FA:cg8_rom = 8'b00000110;
  11'h1FB:cg8_rom = 8'b00001100;
  11'h1FC:cg8_rom = 8'b00010000;
  11'h1FD:cg8_rom = 8'b00000000;
  11'h1FE:cg8_rom = 8'b00010000;
  11'h1FF:cg8_rom = 8'b00000000;
// 40
  11'h200:cg8_rom = 8'b00011100;
  11'h201:cg8_rom = 8'b00100010;
  11'h202:cg8_rom = 8'b01001010;
  11'h203:cg8_rom = 8'b01010110;
  11'h204:cg8_rom = 8'b01001100;
  11'h205:cg8_rom = 8'b00100000;
  11'h206:cg8_rom = 8'b00011110;
  11'h207:cg8_rom = 8'b00000000;
// 41
  11'h208:cg8_rom = 8'b00011000;
  11'h209:cg8_rom = 8'b00100100;
  11'h20A:cg8_rom = 8'b00100100;
  11'h20B:cg8_rom = 8'b01000010;
  11'h20C:cg8_rom = 8'b01111110;
  11'h20D:cg8_rom = 8'b01000010;
  11'h20E:cg8_rom = 8'b01000010;
  11'h20F:cg8_rom = 8'b00000000;
// 42
  11'h210:cg8_rom = 8'b01111100;
  11'h211:cg8_rom = 8'b01000010;
  11'h212:cg8_rom = 8'b01000010;
  11'h213:cg8_rom = 8'b01111100;
  11'h214:cg8_rom = 8'b01000010;
  11'h215:cg8_rom = 8'b01000010;
  11'h216:cg8_rom = 8'b01111100;
  11'h217:cg8_rom = 8'b00000000;
// 43
  11'h218:cg8_rom = 8'b00011100;
  11'h219:cg8_rom = 8'b00100010;
  11'h21A:cg8_rom = 8'b01000000;
  11'h21B:cg8_rom = 8'b01000000;
  11'h21C:cg8_rom = 8'b01000000;
  11'h21D:cg8_rom = 8'b00100010;
  11'h21E:cg8_rom = 8'b00011100;
  11'h21F:cg8_rom = 8'b00000000;
// 44
  11'h220:cg8_rom = 8'b01111000;
  11'h221:cg8_rom = 8'b01000100;
  11'h222:cg8_rom = 8'b01000010;
  11'h223:cg8_rom = 8'b01000010;
  11'h224:cg8_rom = 8'b01000010;
  11'h225:cg8_rom = 8'b01000100;
  11'h226:cg8_rom = 8'b01111000;
  11'h227:cg8_rom = 8'b00000000;
// 45
  11'h228:cg8_rom = 8'b01111110;
  11'h229:cg8_rom = 8'b01000000;
  11'h22A:cg8_rom = 8'b01000000;
  11'h22B:cg8_rom = 8'b01111000;
  11'h22C:cg8_rom = 8'b01000000;
  11'h22D:cg8_rom = 8'b01000000;
  11'h22E:cg8_rom = 8'b01111110;
  11'h22F:cg8_rom = 8'b00000000;
// 46
  11'h230:cg8_rom = 8'b01111110;
  11'h231:cg8_rom = 8'b01000000;
  11'h232:cg8_rom = 8'b01000000;
  11'h233:cg8_rom = 8'b01111000;
  11'h234:cg8_rom = 8'b01000000;
  11'h235:cg8_rom = 8'b01000000;
  11'h236:cg8_rom = 8'b01000000;
  11'h237:cg8_rom = 8'b00000000;
// 47
  11'h238:cg8_rom = 8'b00011100;
  11'h239:cg8_rom = 8'b00100010;
  11'h23A:cg8_rom = 8'b01000000;
  11'h23B:cg8_rom = 8'b01001110;
  11'h23C:cg8_rom = 8'b01000010;
  11'h23D:cg8_rom = 8'b00100010;
  11'h23E:cg8_rom = 8'b00011110;
  11'h23F:cg8_rom = 8'b00000000;
// 48
  11'h240:cg8_rom = 8'b01000010;
  11'h241:cg8_rom = 8'b01000010;
  11'h242:cg8_rom = 8'b01000010;
  11'h243:cg8_rom = 8'b01111110;
  11'h244:cg8_rom = 8'b01000010;
  11'h245:cg8_rom = 8'b01000010;
  11'h246:cg8_rom = 8'b01000010;
  11'h247:cg8_rom = 8'b00000000;
// 49
  11'h248:cg8_rom = 8'b00011100;
  11'h249:cg8_rom = 8'b00001000;
  11'h24A:cg8_rom = 8'b00001000;
  11'h24B:cg8_rom = 8'b00001000;
  11'h24C:cg8_rom = 8'b00001000;
  11'h24D:cg8_rom = 8'b00001000;
  11'h24E:cg8_rom = 8'b00011100;
  11'h24F:cg8_rom = 8'b00000000;
// 4A
  11'h250:cg8_rom = 8'b00001110;
  11'h251:cg8_rom = 8'b00000100;
  11'h252:cg8_rom = 8'b00000100;
  11'h253:cg8_rom = 8'b00000100;
  11'h254:cg8_rom = 8'b00000100;
  11'h255:cg8_rom = 8'b01000100;
  11'h256:cg8_rom = 8'b00111000;
  11'h257:cg8_rom = 8'b00000000;
// 4B
  11'h258:cg8_rom = 8'b01000010;
  11'h259:cg8_rom = 8'b01000100;
  11'h25A:cg8_rom = 8'b01001000;
  11'h25B:cg8_rom = 8'b01110000;
  11'h25C:cg8_rom = 8'b01001000;
  11'h25D:cg8_rom = 8'b01000100;
  11'h25E:cg8_rom = 8'b01000010;
  11'h25F:cg8_rom = 8'b00000000;
// 4C
  11'h260:cg8_rom = 8'b01000000;
  11'h261:cg8_rom = 8'b01000000;
  11'h262:cg8_rom = 8'b01000000;
  11'h263:cg8_rom = 8'b01000000;
  11'h264:cg8_rom = 8'b01000000;
  11'h265:cg8_rom = 8'b01000000;
  11'h266:cg8_rom = 8'b01111110;
  11'h267:cg8_rom = 8'b00000000;
// 4D
  11'h268:cg8_rom = 8'b01000010;
  11'h269:cg8_rom = 8'b01100110;
  11'h26A:cg8_rom = 8'b01011010;
  11'h26B:cg8_rom = 8'b01011010;
  11'h26C:cg8_rom = 8'b01000010;
  11'h26D:cg8_rom = 8'b01000010;
  11'h26E:cg8_rom = 8'b01000010;
  11'h26F:cg8_rom = 8'b00000000;
// 4E
  11'h270:cg8_rom = 8'b01000010;
  11'h271:cg8_rom = 8'b01100010;
  11'h272:cg8_rom = 8'b01010010;
  11'h273:cg8_rom = 8'b01001010;
  11'h274:cg8_rom = 8'b01000110;
  11'h275:cg8_rom = 8'b01000010;
  11'h276:cg8_rom = 8'b01000010;
  11'h277:cg8_rom = 8'b00000000;
// 4F
  11'h278:cg8_rom = 8'b00111100;
  11'h279:cg8_rom = 8'b01000010;
  11'h27A:cg8_rom = 8'b01000010;
  11'h27B:cg8_rom = 8'b01000010;
  11'h27C:cg8_rom = 8'b01000010;
  11'h27D:cg8_rom = 8'b01000010;
  11'h27E:cg8_rom = 8'b00111100;
  11'h27F:cg8_rom = 8'b00000000;
// 50
  11'h280:cg8_rom = 8'b01111100;
  11'h281:cg8_rom = 8'b01000010;
  11'h282:cg8_rom = 8'b01000010;
  11'h283:cg8_rom = 8'b01111100;
  11'h284:cg8_rom = 8'b01000000;
  11'h285:cg8_rom = 8'b01000000;
  11'h286:cg8_rom = 8'b01000000;
  11'h287:cg8_rom = 8'b00000000;
// 51
  11'h288:cg8_rom = 8'b00111100;
  11'h289:cg8_rom = 8'b01000010;
  11'h28A:cg8_rom = 8'b01000010;
  11'h28B:cg8_rom = 8'b01000010;
  11'h28C:cg8_rom = 8'b01001010;
  11'h28D:cg8_rom = 8'b01000100;
  11'h28E:cg8_rom = 8'b00111010;
  11'h28F:cg8_rom = 8'b00000000;
// 52
  11'h290:cg8_rom = 8'b01111100;
  11'h291:cg8_rom = 8'b01000010;
  11'h292:cg8_rom = 8'b01000010;
  11'h293:cg8_rom = 8'b01111100;
  11'h294:cg8_rom = 8'b01000100;
  11'h295:cg8_rom = 8'b01000010;
  11'h296:cg8_rom = 8'b01000010;
  11'h297:cg8_rom = 8'b00000000;
// 53
  11'h298:cg8_rom = 8'b00111100;
  11'h299:cg8_rom = 8'b01000010;
  11'h29A:cg8_rom = 8'b00100000;
  11'h29B:cg8_rom = 8'b00011000;
  11'h29C:cg8_rom = 8'b00000100;
  11'h29D:cg8_rom = 8'b01000010;
  11'h29E:cg8_rom = 8'b00111100;
  11'h29F:cg8_rom = 8'b00000000;
// 54
  11'h2A0:cg8_rom = 8'b00111110;
  11'h2A1:cg8_rom = 8'b00001000;
  11'h2A2:cg8_rom = 8'b00001000;
  11'h2A3:cg8_rom = 8'b00001000;
  11'h2A4:cg8_rom = 8'b00001000;
  11'h2A5:cg8_rom = 8'b00001000;
  11'h2A6:cg8_rom = 8'b00001000;
  11'h2A7:cg8_rom = 8'b00000000;
// 55
  11'h2A8:cg8_rom = 8'b01000010;
  11'h2A9:cg8_rom = 8'b01000010;
  11'h2AA:cg8_rom = 8'b01000010;
  11'h2AB:cg8_rom = 8'b01000010;
  11'h2AC:cg8_rom = 8'b01000010;
  11'h2AD:cg8_rom = 8'b01000010;
  11'h2AE:cg8_rom = 8'b00111100;
  11'h2AF:cg8_rom = 8'b00000000;
// 56
  11'h2B0:cg8_rom = 8'b01000010;
  11'h2B1:cg8_rom = 8'b01000010;
  11'h2B2:cg8_rom = 8'b01000010;
  11'h2B3:cg8_rom = 8'b00100100;
  11'h2B4:cg8_rom = 8'b00100100;
  11'h2B5:cg8_rom = 8'b00011000;
  11'h2B6:cg8_rom = 8'b00011000;
  11'h2B7:cg8_rom = 8'b00000000;
// 57
  11'h2B8:cg8_rom = 8'b01000010;
  11'h2B9:cg8_rom = 8'b01000010;
  11'h2BA:cg8_rom = 8'b01000010;
  11'h2BB:cg8_rom = 8'b01011010;
  11'h2BC:cg8_rom = 8'b01011010;
  11'h2BD:cg8_rom = 8'b01100110;
  11'h2BE:cg8_rom = 8'b01000010;
  11'h2BF:cg8_rom = 8'b00000000;
// 58
  11'h2C0:cg8_rom = 8'b01000010;
  11'h2C1:cg8_rom = 8'b01000010;
  11'h2C2:cg8_rom = 8'b00100100;
  11'h2C3:cg8_rom = 8'b00011000;
  11'h2C4:cg8_rom = 8'b00100100;
  11'h2C5:cg8_rom = 8'b01000010;
  11'h2C6:cg8_rom = 8'b01000010;
  11'h2C7:cg8_rom = 8'b00000000;
// 59
  11'h2C8:cg8_rom = 8'b00100010;
  11'h2C9:cg8_rom = 8'b00100010;
  11'h2CA:cg8_rom = 8'b00100010;
  11'h2CB:cg8_rom = 8'b00011100;
  11'h2CC:cg8_rom = 8'b00001000;
  11'h2CD:cg8_rom = 8'b00001000;
  11'h2CE:cg8_rom = 8'b00001000;
  11'h2CF:cg8_rom = 8'b00000000;
// 5A
  11'h2D0:cg8_rom = 8'b01111110;
  11'h2D1:cg8_rom = 8'b00000010;
  11'h2D2:cg8_rom = 8'b00000100;
  11'h2D3:cg8_rom = 8'b00011000;
  11'h2D4:cg8_rom = 8'b00100000;
  11'h2D5:cg8_rom = 8'b01000000;
  11'h2D6:cg8_rom = 8'b01111110;
  11'h2D7:cg8_rom = 8'b00000000;
// 5B
  11'h2D8:cg8_rom = 8'b00011100;
  11'h2D9:cg8_rom = 8'b00010000;
  11'h2DA:cg8_rom = 8'b00010000;
  11'h2DB:cg8_rom = 8'b00010000;
  11'h2DC:cg8_rom = 8'b00010000;
  11'h2DD:cg8_rom = 8'b00010000;
  11'h2DE:cg8_rom = 8'b00011100;
  11'h2DF:cg8_rom = 8'b00000000;
// 5C
  11'h2E0:cg8_rom = 8'b00100010;
  11'h2E1:cg8_rom = 8'b00100010;
  11'h2E2:cg8_rom = 8'b00010100;
  11'h2E3:cg8_rom = 8'b00111110;
  11'h2E4:cg8_rom = 8'b00001000;
  11'h2E5:cg8_rom = 8'b00111110;
  11'h2E6:cg8_rom = 8'b00001000;
  11'h2E7:cg8_rom = 8'b00000000;
// 5D
  11'h2E8:cg8_rom = 8'b00111000;
  11'h2E9:cg8_rom = 8'b00001000;
  11'h2EA:cg8_rom = 8'b00001000;
  11'h2EB:cg8_rom = 8'b00001000;
  11'h2EC:cg8_rom = 8'b00001000;
  11'h2ED:cg8_rom = 8'b00001000;
  11'h2EE:cg8_rom = 8'b00111000;
  11'h2EF:cg8_rom = 8'b00000000;
// 5E
  11'h2F0:cg8_rom = 8'b00001000;
  11'h2F1:cg8_rom = 8'b00010100;
  11'h2F2:cg8_rom = 8'b00100010;
  11'h2F3:cg8_rom = 8'b00000000;
  11'h2F4:cg8_rom = 8'b00000000;
  11'h2F5:cg8_rom = 8'b00000000;
  11'h2F6:cg8_rom = 8'b00000000;
  11'h2F7:cg8_rom = 8'b00000000;
// 5F
  11'h2F8:cg8_rom = 8'b00000000;
  11'h2F9:cg8_rom = 8'b00000000;
  11'h2FA:cg8_rom = 8'b00000000;
  11'h2FB:cg8_rom = 8'b00000000;
  11'h2FC:cg8_rom = 8'b00000000;
  11'h2FD:cg8_rom = 8'b00000000;
  11'h2FE:cg8_rom = 8'b01111110;
  11'h2FF:cg8_rom = 8'b00000000;
// 60
  11'h300:cg8_rom = 8'b00000110;
  11'h301:cg8_rom = 8'b00000100;
  11'h302:cg8_rom = 8'b00000010;
  11'h303:cg8_rom = 8'b00000000;
  11'h304:cg8_rom = 8'b00000000;
  11'h305:cg8_rom = 8'b00000000;
  11'h306:cg8_rom = 8'b00000000;
  11'h307:cg8_rom = 8'b00000000;
// 61
  11'h308:cg8_rom = 8'b00000000;
  11'h309:cg8_rom = 8'b00000000;
  11'h30A:cg8_rom = 8'b00111100;
  11'h30B:cg8_rom = 8'b00000010;
  11'h30C:cg8_rom = 8'b00111110;
  11'h30D:cg8_rom = 8'b01000010;
  11'h30E:cg8_rom = 8'b00111110;
  11'h30F:cg8_rom = 8'b00000000;
// 62
  11'h310:cg8_rom = 8'b01000000;
  11'h311:cg8_rom = 8'b01000000;
  11'h312:cg8_rom = 8'b01011100;
  11'h313:cg8_rom = 8'b01100010;
  11'h314:cg8_rom = 8'b01000010;
  11'h315:cg8_rom = 8'b01100010;
  11'h316:cg8_rom = 8'b01011100;
  11'h317:cg8_rom = 8'b00000000;
// 63
  11'h318:cg8_rom = 8'b00000000;
  11'h319:cg8_rom = 8'b00000000;
  11'h31A:cg8_rom = 8'b00111100;
  11'h31B:cg8_rom = 8'b01000010;
  11'h31C:cg8_rom = 8'b01000000;
  11'h31D:cg8_rom = 8'b01000010;
  11'h31E:cg8_rom = 8'b00111100;
  11'h31F:cg8_rom = 8'b00000000;
// 64
  11'h320:cg8_rom = 8'b00000010;
  11'h321:cg8_rom = 8'b00000010;
  11'h322:cg8_rom = 8'b00111010;
  11'h323:cg8_rom = 8'b01000110;
  11'h324:cg8_rom = 8'b01000010;
  11'h325:cg8_rom = 8'b01000110;
  11'h326:cg8_rom = 8'b00111010;
  11'h327:cg8_rom = 8'b00000000;
// 65
  11'h328:cg8_rom = 8'b00000000;
  11'h329:cg8_rom = 8'b00000000;
  11'h32A:cg8_rom = 8'b00111100;
  11'h32B:cg8_rom = 8'b01000010;
  11'h32C:cg8_rom = 8'b01111110;
  11'h32D:cg8_rom = 8'b01000000;
  11'h32E:cg8_rom = 8'b00111100;
  11'h32F:cg8_rom = 8'b00000000;
// 66
  11'h330:cg8_rom = 8'b00001110;
  11'h331:cg8_rom = 8'b00010000;
  11'h332:cg8_rom = 8'b00010000;
  11'h333:cg8_rom = 8'b01111100;
  11'h334:cg8_rom = 8'b00010000;
  11'h335:cg8_rom = 8'b00010000;
  11'h336:cg8_rom = 8'b00010000;
  11'h337:cg8_rom = 8'b00000000;
// 67
  11'h338:cg8_rom = 8'b00000000;
  11'h339:cg8_rom = 8'b00000000;
  11'h33A:cg8_rom = 8'b00111010;
  11'h33B:cg8_rom = 8'b01000110;
  11'h33C:cg8_rom = 8'b01000110;
  11'h33D:cg8_rom = 8'b00111010;
  11'h33E:cg8_rom = 8'b00000010;
  11'h33F:cg8_rom = 8'b00111100;
// 68
  11'h340:cg8_rom = 8'b01000000;
  11'h341:cg8_rom = 8'b01000000;
  11'h342:cg8_rom = 8'b01011100;
  11'h343:cg8_rom = 8'b01100010;
  11'h344:cg8_rom = 8'b01000010;
  11'h345:cg8_rom = 8'b01000010;
  11'h346:cg8_rom = 8'b01000010;
  11'h347:cg8_rom = 8'b00000000;
// 69
  11'h348:cg8_rom = 8'b00001000;
  11'h349:cg8_rom = 8'b00000000;
  11'h34A:cg8_rom = 8'b00011000;
  11'h34B:cg8_rom = 8'b00001000;
  11'h34C:cg8_rom = 8'b00001000;
  11'h34D:cg8_rom = 8'b00001000;
  11'h34E:cg8_rom = 8'b00011100;
  11'h34F:cg8_rom = 8'b00000000;
// 6A
  11'h350:cg8_rom = 8'b00000100;
  11'h351:cg8_rom = 8'b00000000;
  11'h352:cg8_rom = 8'b00001100;
  11'h353:cg8_rom = 8'b00000100;
  11'h354:cg8_rom = 8'b00000100;
  11'h355:cg8_rom = 8'b00000100;
  11'h356:cg8_rom = 8'b00100100;
  11'h357:cg8_rom = 8'b00011000;
// 6B
  11'h358:cg8_rom = 8'b01000000;
  11'h359:cg8_rom = 8'b01000000;
  11'h35A:cg8_rom = 8'b01000100;
  11'h35B:cg8_rom = 8'b01001000;
  11'h35C:cg8_rom = 8'b01010000;
  11'h35D:cg8_rom = 8'b01101000;
  11'h35E:cg8_rom = 8'b01000100;
  11'h35F:cg8_rom = 8'b00000000;
// 6C
  11'h360:cg8_rom = 8'b00011000;
  11'h361:cg8_rom = 8'b00001000;
  11'h362:cg8_rom = 8'b00001000;
  11'h363:cg8_rom = 8'b00001000;
  11'h364:cg8_rom = 8'b00001000;
  11'h365:cg8_rom = 8'b00001000;
  11'h366:cg8_rom = 8'b00011100;
  11'h367:cg8_rom = 8'b00000000;
// 6D
  11'h368:cg8_rom = 8'b00000000;
  11'h369:cg8_rom = 8'b00000000;
  11'h36A:cg8_rom = 8'b01110110;
  11'h36B:cg8_rom = 8'b01001001;
  11'h36C:cg8_rom = 8'b01001001;
  11'h36D:cg8_rom = 8'b01001001;
  11'h36E:cg8_rom = 8'b01001001;
  11'h36F:cg8_rom = 8'b00000000;
// 6E
  11'h370:cg8_rom = 8'b00000000;
  11'h371:cg8_rom = 8'b00000000;
  11'h372:cg8_rom = 8'b01011100;
  11'h373:cg8_rom = 8'b01100010;
  11'h374:cg8_rom = 8'b01000010;
  11'h375:cg8_rom = 8'b01000010;
  11'h376:cg8_rom = 8'b01000010;
  11'h377:cg8_rom = 8'b00000000;
// 6F
  11'h378:cg8_rom = 8'b00000000;
  11'h379:cg8_rom = 8'b00000000;
  11'h37A:cg8_rom = 8'b00111100;
  11'h37B:cg8_rom = 8'b01000010;
  11'h37C:cg8_rom = 8'b01000010;
  11'h37D:cg8_rom = 8'b01000010;
  11'h37E:cg8_rom = 8'b00111100;
  11'h37F:cg8_rom = 8'b00000000;
// 70
  11'h380:cg8_rom = 8'b00000000;
  11'h381:cg8_rom = 8'b00000000;
  11'h382:cg8_rom = 8'b01011100;
  11'h383:cg8_rom = 8'b01100010;
  11'h384:cg8_rom = 8'b01100010;
  11'h385:cg8_rom = 8'b01011100;
  11'h386:cg8_rom = 8'b01000000;
  11'h387:cg8_rom = 8'b01000000;
// 71
  11'h388:cg8_rom = 8'b00000000;
  11'h389:cg8_rom = 8'b00000000;
  11'h38A:cg8_rom = 8'b00111010;
  11'h38B:cg8_rom = 8'b01000110;
  11'h38C:cg8_rom = 8'b01000110;
  11'h38D:cg8_rom = 8'b00111010;
  11'h38E:cg8_rom = 8'b00000010;
  11'h38F:cg8_rom = 8'b00000010;
// 72
  11'h390:cg8_rom = 8'b00000000;
  11'h391:cg8_rom = 8'b00000000;
  11'h392:cg8_rom = 8'b01011100;
  11'h393:cg8_rom = 8'b01100010;
  11'h394:cg8_rom = 8'b01000000;
  11'h395:cg8_rom = 8'b01000000;
  11'h396:cg8_rom = 8'b01000000;
  11'h397:cg8_rom = 8'b00000000;
// 73
  11'h398:cg8_rom = 8'b00000000;
  11'h399:cg8_rom = 8'b00000000;
  11'h39A:cg8_rom = 8'b00111100;
  11'h39B:cg8_rom = 8'b01000000;
  11'h39C:cg8_rom = 8'b00111100;
  11'h39D:cg8_rom = 8'b00000010;
  11'h39E:cg8_rom = 8'b01111100;
  11'h39F:cg8_rom = 8'b00000000;
// 74
  11'h3A0:cg8_rom = 8'b00010000;
  11'h3A1:cg8_rom = 8'b00010000;
  11'h3A2:cg8_rom = 8'b01111100;
  11'h3A3:cg8_rom = 8'b00010000;
  11'h3A4:cg8_rom = 8'b00010000;
  11'h3A5:cg8_rom = 8'b00010000;
  11'h3A6:cg8_rom = 8'b00001100;
  11'h3A7:cg8_rom = 8'b00000000;
// 75
  11'h3A8:cg8_rom = 8'b00000000;
  11'h3A9:cg8_rom = 8'b00000000;
  11'h3AA:cg8_rom = 8'b01000010;
  11'h3AB:cg8_rom = 8'b01000010;
  11'h3AC:cg8_rom = 8'b01000010;
  11'h3AD:cg8_rom = 8'b01000110;
  11'h3AE:cg8_rom = 8'b00111010;
  11'h3AF:cg8_rom = 8'b00000000;
// 76
  11'h3B0:cg8_rom = 8'b00000000;
  11'h3B1:cg8_rom = 8'b00000000;
  11'h3B2:cg8_rom = 8'b01000010;
  11'h3B3:cg8_rom = 8'b01000010;
  11'h3B4:cg8_rom = 8'b01000010;
  11'h3B5:cg8_rom = 8'b00100100;
  11'h3B6:cg8_rom = 8'b00011000;
  11'h3B7:cg8_rom = 8'b00000000;
// 77
  11'h3B8:cg8_rom = 8'b00000000;
  11'h3B9:cg8_rom = 8'b00000000;
  11'h3BA:cg8_rom = 8'b01000001;
  11'h3BB:cg8_rom = 8'b01001001;
  11'h3BC:cg8_rom = 8'b01001001;
  11'h3BD:cg8_rom = 8'b01001001;
  11'h3BE:cg8_rom = 8'b00110110;
  11'h3BF:cg8_rom = 8'b00000000;
// 78
  11'h3C0:cg8_rom = 8'b00000000;
  11'h3C1:cg8_rom = 8'b00000000;
  11'h3C2:cg8_rom = 8'b01000010;
  11'h3C3:cg8_rom = 8'b00100100;
  11'h3C4:cg8_rom = 8'b00011000;
  11'h3C5:cg8_rom = 8'b00100100;
  11'h3C6:cg8_rom = 8'b01000010;
  11'h3C7:cg8_rom = 8'b00000000;
// 79
  11'h3C8:cg8_rom = 8'b00000000;
  11'h3C9:cg8_rom = 8'b00000000;
  11'h3CA:cg8_rom = 8'b01000010;
  11'h3CB:cg8_rom = 8'b01000010;
  11'h3CC:cg8_rom = 8'b01000010;
  11'h3CD:cg8_rom = 8'b00111110;
  11'h3CE:cg8_rom = 8'b00000010;
  11'h3CF:cg8_rom = 8'b00111100;
// 7A
  11'h3D0:cg8_rom = 8'b00000000;
  11'h3D1:cg8_rom = 8'b00000000;
  11'h3D2:cg8_rom = 8'b01111110;
  11'h3D3:cg8_rom = 8'b00000100;
  11'h3D4:cg8_rom = 8'b00011000;
  11'h3D5:cg8_rom = 8'b00100000;
  11'h3D6:cg8_rom = 8'b01111110;
  11'h3D7:cg8_rom = 8'b00000000;
// 7B
  11'h3D8:cg8_rom = 8'b00001100;
  11'h3D9:cg8_rom = 8'b00010000;
  11'h3DA:cg8_rom = 8'b00010000;
  11'h3DB:cg8_rom = 8'b00100000;
  11'h3DC:cg8_rom = 8'b00010000;
  11'h3DD:cg8_rom = 8'b00010000;
  11'h3DE:cg8_rom = 8'b00001100;
  11'h3DF:cg8_rom = 8'b00000000;
// 7C
  11'h3E0:cg8_rom = 8'b00001000;
  11'h3E1:cg8_rom = 8'b00001000;
  11'h3E2:cg8_rom = 8'b00001000;
  11'h3E3:cg8_rom = 8'b00001000;
  11'h3E4:cg8_rom = 8'b00001000;
  11'h3E5:cg8_rom = 8'b00001000;
  11'h3E6:cg8_rom = 8'b00001000;
  11'h3E7:cg8_rom = 8'b00000000;
// 7D
  11'h3E8:cg8_rom = 8'b00110000;
  11'h3E9:cg8_rom = 8'b00001000;
  11'h3EA:cg8_rom = 8'b00001000;
  11'h3EB:cg8_rom = 8'b00000100;
  11'h3EC:cg8_rom = 8'b00001000;
  11'h3ED:cg8_rom = 8'b00001000;
  11'h3EE:cg8_rom = 8'b00110000;
  11'h3EF:cg8_rom = 8'b00000000;
// 7E
  11'h3F0:cg8_rom = 8'b00110000;
  11'h3F1:cg8_rom = 8'b01001001;
  11'h3F2:cg8_rom = 8'b00000110;
  11'h3F3:cg8_rom = 8'b00000000;
  11'h3F4:cg8_rom = 8'b00000000;
  11'h3F5:cg8_rom = 8'b00000000;
  11'h3F6:cg8_rom = 8'b00000000;
  11'h3F7:cg8_rom = 8'b00000000;
// 7F
  11'h3F8:cg8_rom = 8'b00000000;
  11'h3F9:cg8_rom = 8'b00000000;
  11'h3FA:cg8_rom = 8'b00000010;
  11'h3FB:cg8_rom = 8'b01111100;
  11'h3FC:cg8_rom = 8'b00101000;
  11'h3FD:cg8_rom = 8'b00101000;
  11'h3FE:cg8_rom = 8'b00101100;
  11'h3FF:cg8_rom = 8'b00000000;
// 80
  11'h400:cg8_rom = 8'b00000000;
  11'h401:cg8_rom = 8'b00000000;
  11'h402:cg8_rom = 8'b00000000;
  11'h403:cg8_rom = 8'b00000000;
  11'h404:cg8_rom = 8'b00000000;
  11'h405:cg8_rom = 8'b00000000;
  11'h406:cg8_rom = 8'b00000000;
  11'h407:cg8_rom = 8'b11111111;
// 81
  11'h408:cg8_rom = 8'b00000000;
  11'h409:cg8_rom = 8'b00000000;
  11'h40A:cg8_rom = 8'b00000000;
  11'h40B:cg8_rom = 8'b00000000;
  11'h40C:cg8_rom = 8'b00000000;
  11'h40D:cg8_rom = 8'b00000000;
  11'h40E:cg8_rom = 8'b11111111;
  11'h40F:cg8_rom = 8'b11111111;
// 82
  11'h410:cg8_rom = 8'b00000000;
  11'h411:cg8_rom = 8'b00000000;
  11'h412:cg8_rom = 8'b00000000;
  11'h413:cg8_rom = 8'b00000000;
  11'h414:cg8_rom = 8'b00000000;
  11'h415:cg8_rom = 8'b11111111;
  11'h416:cg8_rom = 8'b11111111;
  11'h417:cg8_rom = 8'b11111111;
// 83
  11'h418:cg8_rom = 8'b00000000;
  11'h419:cg8_rom = 8'b00000000;
  11'h41A:cg8_rom = 8'b00000000;
  11'h41B:cg8_rom = 8'b00000000;
  11'h41C:cg8_rom = 8'b11111111;
  11'h41D:cg8_rom = 8'b11111111;
  11'h41E:cg8_rom = 8'b11111111;
  11'h41F:cg8_rom = 8'b11111111;
// 84
  11'h420:cg8_rom = 8'b00000000;
  11'h421:cg8_rom = 8'b00000000;
  11'h422:cg8_rom = 8'b00000000;
  11'h423:cg8_rom = 8'b11111111;
  11'h424:cg8_rom = 8'b11111111;
  11'h425:cg8_rom = 8'b11111111;
  11'h426:cg8_rom = 8'b11111111;
  11'h427:cg8_rom = 8'b11111111;
// 85
  11'h428:cg8_rom = 8'b00000000;
  11'h429:cg8_rom = 8'b00000000;
  11'h42A:cg8_rom = 8'b11111111;
  11'h42B:cg8_rom = 8'b11111111;
  11'h42C:cg8_rom = 8'b11111111;
  11'h42D:cg8_rom = 8'b11111111;
  11'h42E:cg8_rom = 8'b11111111;
  11'h42F:cg8_rom = 8'b11111111;
// 86
  11'h430:cg8_rom = 8'b00000000;
  11'h431:cg8_rom = 8'b11111111;
  11'h432:cg8_rom = 8'b11111111;
  11'h433:cg8_rom = 8'b11111111;
  11'h434:cg8_rom = 8'b11111111;
  11'h435:cg8_rom = 8'b11111111;
  11'h436:cg8_rom = 8'b11111111;
  11'h437:cg8_rom = 8'b11111111;
// 87
  11'h438:cg8_rom = 8'b11111111;
  11'h439:cg8_rom = 8'b11111111;
  11'h43A:cg8_rom = 8'b11111111;
  11'h43B:cg8_rom = 8'b11111111;
  11'h43C:cg8_rom = 8'b11111111;
  11'h43D:cg8_rom = 8'b11111111;
  11'h43E:cg8_rom = 8'b11111111;
  11'h43F:cg8_rom = 8'b11111111;
// 88
  11'h440:cg8_rom = 8'b10000000;
  11'h441:cg8_rom = 8'b10000000;
  11'h442:cg8_rom = 8'b10000000;
  11'h443:cg8_rom = 8'b10000000;
  11'h444:cg8_rom = 8'b10000000;
  11'h445:cg8_rom = 8'b10000000;
  11'h446:cg8_rom = 8'b10000000;
  11'h447:cg8_rom = 8'b10000000;
// 89
  11'h448:cg8_rom = 8'b11000000;
  11'h449:cg8_rom = 8'b11000000;
  11'h44A:cg8_rom = 8'b11000000;
  11'h44B:cg8_rom = 8'b11000000;
  11'h44C:cg8_rom = 8'b11000000;
  11'h44D:cg8_rom = 8'b11000000;
  11'h44E:cg8_rom = 8'b11000000;
  11'h44F:cg8_rom = 8'b11000000;
// 8A
  11'h450:cg8_rom = 8'b11100000;
  11'h451:cg8_rom = 8'b11100000;
  11'h452:cg8_rom = 8'b11100000;
  11'h453:cg8_rom = 8'b11100000;
  11'h454:cg8_rom = 8'b11100000;
  11'h455:cg8_rom = 8'b11100000;
  11'h456:cg8_rom = 8'b11100000;
  11'h457:cg8_rom = 8'b11100000;
// 8B
  11'h458:cg8_rom = 8'b11110000;
  11'h459:cg8_rom = 8'b11110000;
  11'h45A:cg8_rom = 8'b11110000;
  11'h45B:cg8_rom = 8'b11110000;
  11'h45C:cg8_rom = 8'b11110000;
  11'h45D:cg8_rom = 8'b11110000;
  11'h45E:cg8_rom = 8'b11110000;
  11'h45F:cg8_rom = 8'b11110000;
// 8C
  11'h460:cg8_rom = 8'b11111000;
  11'h461:cg8_rom = 8'b11111000;
  11'h462:cg8_rom = 8'b11111000;
  11'h463:cg8_rom = 8'b11111000;
  11'h464:cg8_rom = 8'b11111000;
  11'h465:cg8_rom = 8'b11111000;
  11'h466:cg8_rom = 8'b11111000;
  11'h467:cg8_rom = 8'b11111000;
// 8D
  11'h468:cg8_rom = 8'b11111100;
  11'h469:cg8_rom = 8'b11111100;
  11'h46A:cg8_rom = 8'b11111100;
  11'h46B:cg8_rom = 8'b11111100;
  11'h46C:cg8_rom = 8'b11111100;
  11'h46D:cg8_rom = 8'b11111100;
  11'h46E:cg8_rom = 8'b11111100;
  11'h46F:cg8_rom = 8'b11111100;
// 8E
  11'h470:cg8_rom = 8'b11111110;
  11'h471:cg8_rom = 8'b11111110;
  11'h472:cg8_rom = 8'b11111110;
  11'h473:cg8_rom = 8'b11111110;
  11'h474:cg8_rom = 8'b11111110;
  11'h475:cg8_rom = 8'b11111110;
  11'h476:cg8_rom = 8'b11111110;
  11'h477:cg8_rom = 8'b11111110;
// 8F
  11'h478:cg8_rom = 8'b00000001;
  11'h479:cg8_rom = 8'b00000010;
  11'h47A:cg8_rom = 8'b00000100;
  11'h47B:cg8_rom = 8'b00001000;
  11'h47C:cg8_rom = 8'b00010000;
  11'h47D:cg8_rom = 8'b00100000;
  11'h47E:cg8_rom = 8'b01000000;
  11'h47F:cg8_rom = 8'b10000000;
// 90
  11'h480:cg8_rom = 8'b00000000;
  11'h481:cg8_rom = 8'b00000000;
  11'h482:cg8_rom = 8'b00000000;
  11'h483:cg8_rom = 8'b11111111;
  11'h484:cg8_rom = 8'b00000000;
  11'h485:cg8_rom = 8'b00000000;
  11'h486:cg8_rom = 8'b00000000;
  11'h487:cg8_rom = 8'b00000000;
// 91
  11'h488:cg8_rom = 8'b00010000;
  11'h489:cg8_rom = 8'b00010000;
  11'h48A:cg8_rom = 8'b00010000;
  11'h48B:cg8_rom = 8'b00010000;
  11'h48C:cg8_rom = 8'b00010000;
  11'h48D:cg8_rom = 8'b00010000;
  11'h48E:cg8_rom = 8'b00010000;
  11'h48F:cg8_rom = 8'b00010000;
// 92
  11'h490:cg8_rom = 8'b00010000;
  11'h491:cg8_rom = 8'b00010000;
  11'h492:cg8_rom = 8'b00010000;
  11'h493:cg8_rom = 8'b11111111;
  11'h494:cg8_rom = 8'b00000000;
  11'h495:cg8_rom = 8'b00000000;
  11'h496:cg8_rom = 8'b00000000;
  11'h497:cg8_rom = 8'b00000000;
// 93
  11'h498:cg8_rom = 8'b00000000;
  11'h499:cg8_rom = 8'b00000000;
  11'h49A:cg8_rom = 8'b00000000;
  11'h49B:cg8_rom = 8'b11111111;
  11'h49C:cg8_rom = 8'b00010000;
  11'h49D:cg8_rom = 8'b00010000;
  11'h49E:cg8_rom = 8'b00010000;
  11'h49F:cg8_rom = 8'b00010000;
// 94
  11'h4A0:cg8_rom = 8'b00010000;
  11'h4A1:cg8_rom = 8'b00010000;
  11'h4A2:cg8_rom = 8'b00010000;
  11'h4A3:cg8_rom = 8'b11110000;
  11'h4A4:cg8_rom = 8'b00010000;
  11'h4A5:cg8_rom = 8'b00010000;
  11'h4A6:cg8_rom = 8'b00010000;
  11'h4A7:cg8_rom = 8'b00010000;
// 95
  11'h4A8:cg8_rom = 8'b00010000;
  11'h4A9:cg8_rom = 8'b00010000;
  11'h4AA:cg8_rom = 8'b00010000;
  11'h4AB:cg8_rom = 8'b00011111;
  11'h4AC:cg8_rom = 8'b00010000;
  11'h4AD:cg8_rom = 8'b00010000;
  11'h4AE:cg8_rom = 8'b00010000;
  11'h4AF:cg8_rom = 8'b00010000;
// 96
  11'h4B0:cg8_rom = 8'b00010000;
  11'h4B1:cg8_rom = 8'b00010000;
  11'h4B2:cg8_rom = 8'b00010000;
  11'h4B3:cg8_rom = 8'b11111111;
  11'h4B4:cg8_rom = 8'b00010000;
  11'h4B5:cg8_rom = 8'b00010000;
  11'h4B6:cg8_rom = 8'b00010000;
  11'h4B7:cg8_rom = 8'b00010000;
// 97
  11'h4B8:cg8_rom = 8'b00000000;
  11'h4B9:cg8_rom = 8'b00000000;
  11'h4BA:cg8_rom = 8'b00000000;
  11'h4BB:cg8_rom = 8'b11110000;
  11'h4BC:cg8_rom = 8'b00010000;
  11'h4BD:cg8_rom = 8'b00010000;
  11'h4BE:cg8_rom = 8'b00010000;
  11'h4BF:cg8_rom = 8'b00010000;
// 98
  11'h4C0:cg8_rom = 8'b00010000;
  11'h4C1:cg8_rom = 8'b00010000;
  11'h4C2:cg8_rom = 8'b00010000;
  11'h4C3:cg8_rom = 8'b11110000;
  11'h4C4:cg8_rom = 8'b00000000;
  11'h4C5:cg8_rom = 8'b00000000;
  11'h4C6:cg8_rom = 8'b00000000;
  11'h4C7:cg8_rom = 8'b00000000;
// 99
  11'h4C8:cg8_rom = 8'b00010000;
  11'h4C9:cg8_rom = 8'b00010000;
  11'h4CA:cg8_rom = 8'b00010000;
  11'h4CB:cg8_rom = 8'b00011111;
  11'h4CC:cg8_rom = 8'b00000000;
  11'h4CD:cg8_rom = 8'b00000000;
  11'h4CE:cg8_rom = 8'b00000000;
  11'h4CF:cg8_rom = 8'b00000000;
// 9A
  11'h4D0:cg8_rom = 8'b00000000;
  11'h4D1:cg8_rom = 8'b00000000;
  11'h4D2:cg8_rom = 8'b00000000;
  11'h4D3:cg8_rom = 8'b00011111;
  11'h4D4:cg8_rom = 8'b00010000;
  11'h4D5:cg8_rom = 8'b00010000;
  11'h4D6:cg8_rom = 8'b00010000;
  11'h4D7:cg8_rom = 8'b00010000;
// 9B
  11'h4D8:cg8_rom = 8'b00000000;
  11'h4D9:cg8_rom = 8'b00000000;
  11'h4DA:cg8_rom = 8'b00000000;
  11'h4DB:cg8_rom = 8'b11000000;
  11'h4DC:cg8_rom = 8'b00100000;
  11'h4DD:cg8_rom = 8'b00010000;
  11'h4DE:cg8_rom = 8'b00010000;
  11'h4DF:cg8_rom = 8'b00010000;
// 9C
  11'h4E0:cg8_rom = 8'b00010000;
  11'h4E1:cg8_rom = 8'b00010000;
  11'h4E2:cg8_rom = 8'b00001000;
  11'h4E3:cg8_rom = 8'b00000111;
  11'h4E4:cg8_rom = 8'b00000000;
  11'h4E5:cg8_rom = 8'b00000000;
  11'h4E6:cg8_rom = 8'b00000000;
  11'h4E7:cg8_rom = 8'b00000000;
// 9D
  11'h4E8:cg8_rom = 8'b00010000;
  11'h4E9:cg8_rom = 8'b00010000;
  11'h4EA:cg8_rom = 8'b00100000;
  11'h4EB:cg8_rom = 8'b11000000;
  11'h4EC:cg8_rom = 8'b00000000;
  11'h4ED:cg8_rom = 8'b00000000;
  11'h4EE:cg8_rom = 8'b00000000;
  11'h4EF:cg8_rom = 8'b00000000;
// 9E
  11'h4F0:cg8_rom = 8'b00000000;
  11'h4F1:cg8_rom = 8'b00000000;
  11'h4F2:cg8_rom = 8'b00000000;
  11'h4F3:cg8_rom = 8'b00000111;
  11'h4F4:cg8_rom = 8'b00001000;
  11'h4F5:cg8_rom = 8'b00010000;
  11'h4F6:cg8_rom = 8'b00010000;
  11'h4F7:cg8_rom = 8'b00010000;
// 9F
  11'h4F8:cg8_rom = 8'b10000000;
  11'h4F9:cg8_rom = 8'b01000000;
  11'h4FA:cg8_rom = 8'b00100000;
  11'h4FB:cg8_rom = 8'b00010000;
  11'h4FC:cg8_rom = 8'b00001000;
  11'h4FD:cg8_rom = 8'b00000100;
  11'h4FE:cg8_rom = 8'b00000010;
  11'h4FF:cg8_rom = 8'b00000001;
// A0
  11'h500:cg8_rom = 8'b00000000;
  11'h501:cg8_rom = 8'b00000000;
  11'h502:cg8_rom = 8'b00000000;
  11'h503:cg8_rom = 8'b00000000;
  11'h504:cg8_rom = 8'b00000000;
  11'h505:cg8_rom = 8'b00000000;
  11'h506:cg8_rom = 8'b00000000;
  11'h507:cg8_rom = 8'b00000000;
// A1
  11'h508:cg8_rom = 8'b00000000;
  11'h509:cg8_rom = 8'b00000000;
  11'h50A:cg8_rom = 8'b00000000;
  11'h50B:cg8_rom = 8'b00000000;
  11'h50C:cg8_rom = 8'b00111000;
  11'h50D:cg8_rom = 8'b00101000;
  11'h50E:cg8_rom = 8'b00111000;
  11'h50F:cg8_rom = 8'b00000000;
// A2
  11'h510:cg8_rom = 8'b00011100;
  11'h511:cg8_rom = 8'b00010000;
  11'h512:cg8_rom = 8'b00010000;
  11'h513:cg8_rom = 8'b00010000;
  11'h514:cg8_rom = 8'b00000000;
  11'h515:cg8_rom = 8'b00000000;
  11'h516:cg8_rom = 8'b00000000;
  11'h517:cg8_rom = 8'b00000000;
// A3
  11'h518:cg8_rom = 8'b00000000;
  11'h519:cg8_rom = 8'b00000000;
  11'h51A:cg8_rom = 8'b00000000;
  11'h51B:cg8_rom = 8'b00001000;
  11'h51C:cg8_rom = 8'b00001000;
  11'h51D:cg8_rom = 8'b00001000;
  11'h51E:cg8_rom = 8'b00111000;
  11'h51F:cg8_rom = 8'b00000000;
// A4
  11'h520:cg8_rom = 8'b00000000;
  11'h521:cg8_rom = 8'b00000000;
  11'h522:cg8_rom = 8'b00000000;
  11'h523:cg8_rom = 8'b00000000;
  11'h524:cg8_rom = 8'b00100000;
  11'h525:cg8_rom = 8'b00010000;
  11'h526:cg8_rom = 8'b00001000;
  11'h527:cg8_rom = 8'b00000000;
// A5
  11'h528:cg8_rom = 8'b00000000;
  11'h529:cg8_rom = 8'b00000000;
  11'h52A:cg8_rom = 8'b00000000;
  11'h52B:cg8_rom = 8'b00011000;
  11'h52C:cg8_rom = 8'b00011000;
  11'h52D:cg8_rom = 8'b00000000;
  11'h52E:cg8_rom = 8'b00000000;
  11'h52F:cg8_rom = 8'b00000000;
// A6
  11'h530:cg8_rom = 8'b00000000;
  11'h531:cg8_rom = 8'b00111110;
  11'h532:cg8_rom = 8'b00000010;
  11'h533:cg8_rom = 8'b00111110;
  11'h534:cg8_rom = 8'b00000010;
  11'h535:cg8_rom = 8'b00000100;
  11'h536:cg8_rom = 8'b00011000;
  11'h537:cg8_rom = 8'b00000000;
// A7
  11'h538:cg8_rom = 8'b00000000;
  11'h539:cg8_rom = 8'b00000000;
  11'h53A:cg8_rom = 8'b00111110;
  11'h53B:cg8_rom = 8'b00000010;
  11'h53C:cg8_rom = 8'b00001100;
  11'h53D:cg8_rom = 8'b00001000;
  11'h53E:cg8_rom = 8'b00010000;
  11'h53F:cg8_rom = 8'b00000000;
// A8
  11'h540:cg8_rom = 8'b00000000;
  11'h541:cg8_rom = 8'b00000000;
  11'h542:cg8_rom = 8'b00000100;
  11'h543:cg8_rom = 8'b00001000;
  11'h544:cg8_rom = 8'b00011000;
  11'h545:cg8_rom = 8'b00101000;
  11'h546:cg8_rom = 8'b00001000;
  11'h547:cg8_rom = 8'b00000000;
// A9
  11'h548:cg8_rom = 8'b00000000;
  11'h549:cg8_rom = 8'b00000000;
  11'h54A:cg8_rom = 8'b00001000;
  11'h54B:cg8_rom = 8'b00111110;
  11'h54C:cg8_rom = 8'b00100010;
  11'h54D:cg8_rom = 8'b00000010;
  11'h54E:cg8_rom = 8'b00001100;
  11'h54F:cg8_rom = 8'b00000000;
// AA
  11'h550:cg8_rom = 8'b00000000;
  11'h551:cg8_rom = 8'b00000000;
  11'h552:cg8_rom = 8'b00000000;
  11'h553:cg8_rom = 8'b00111110;
  11'h554:cg8_rom = 8'b00001000;
  11'h555:cg8_rom = 8'b00001000;
  11'h556:cg8_rom = 8'b00111110;
  11'h557:cg8_rom = 8'b00000000;
// AB
  11'h558:cg8_rom = 8'b00000000;
  11'h559:cg8_rom = 8'b00000000;
  11'h55A:cg8_rom = 8'b00000100;
  11'h55B:cg8_rom = 8'b00111110;
  11'h55C:cg8_rom = 8'b00001100;
  11'h55D:cg8_rom = 8'b00010100;
  11'h55E:cg8_rom = 8'b00100100;
  11'h55F:cg8_rom = 8'b00000000;
// AC
  11'h560:cg8_rom = 8'b00000000;
  11'h561:cg8_rom = 8'b00000000;
  11'h562:cg8_rom = 8'b00010000;
  11'h563:cg8_rom = 8'b00111110;
  11'h564:cg8_rom = 8'b00010010;
  11'h565:cg8_rom = 8'b00010100;
  11'h566:cg8_rom = 8'b00010000;
  11'h567:cg8_rom = 8'b00000000;
// AD
  11'h568:cg8_rom = 8'b00000000;
  11'h569:cg8_rom = 8'b00000000;
  11'h56A:cg8_rom = 8'b00000000;
  11'h56B:cg8_rom = 8'b00011100;
  11'h56C:cg8_rom = 8'b00000100;
  11'h56D:cg8_rom = 8'b00000100;
  11'h56E:cg8_rom = 8'b00111110;
  11'h56F:cg8_rom = 8'b00000000;
// AE
  11'h570:cg8_rom = 8'b00000000;
  11'h571:cg8_rom = 8'b00000000;
  11'h572:cg8_rom = 8'b00111100;
  11'h573:cg8_rom = 8'b00000100;
  11'h574:cg8_rom = 8'b00111100;
  11'h575:cg8_rom = 8'b00000100;
  11'h576:cg8_rom = 8'b00111100;
  11'h577:cg8_rom = 8'b00000000;
// AF
  11'h578:cg8_rom = 8'b00000000;
  11'h579:cg8_rom = 8'b00000000;
  11'h57A:cg8_rom = 8'b00000000;
  11'h57B:cg8_rom = 8'b00101010;
  11'h57C:cg8_rom = 8'b00101010;
  11'h57D:cg8_rom = 8'b00000010;
  11'h57E:cg8_rom = 8'b00001100;
  11'h57F:cg8_rom = 8'b00000000;
// B0
  11'h580:cg8_rom = 8'b00000000;
  11'h581:cg8_rom = 8'b00000000;
  11'h582:cg8_rom = 8'b00000000;
  11'h583:cg8_rom = 8'b00111110;
  11'h584:cg8_rom = 8'b00000000;
  11'h585:cg8_rom = 8'b00000000;
  11'h586:cg8_rom = 8'b00000000;
  11'h587:cg8_rom = 8'b00000000;
// B1
  11'h588:cg8_rom = 8'b00000000;
  11'h589:cg8_rom = 8'b01111110;
  11'h58A:cg8_rom = 8'b00000010;
  11'h58B:cg8_rom = 8'b00010100;
  11'h58C:cg8_rom = 8'b00011000;
  11'h58D:cg8_rom = 8'b00010000;
  11'h58E:cg8_rom = 8'b00100000;
  11'h58F:cg8_rom = 8'b00000000;
// B2
  11'h590:cg8_rom = 8'b00000010;
  11'h591:cg8_rom = 8'b00000100;
  11'h592:cg8_rom = 8'b00001000;
  11'h593:cg8_rom = 8'b00011000;
  11'h594:cg8_rom = 8'b00101000;
  11'h595:cg8_rom = 8'b00001000;
  11'h596:cg8_rom = 8'b00001000;
  11'h597:cg8_rom = 8'b00000000;
// B3
  11'h598:cg8_rom = 8'b00000000;
  11'h599:cg8_rom = 8'b00001000;
  11'h59A:cg8_rom = 8'b01111110;
  11'h59B:cg8_rom = 8'b01000010;
  11'h59C:cg8_rom = 8'b00000010;
  11'h59D:cg8_rom = 8'b00000100;
  11'h59E:cg8_rom = 8'b00011000;
  11'h59F:cg8_rom = 8'b00000000;
// B4
  11'h5A0:cg8_rom = 8'b00000000;
  11'h5A1:cg8_rom = 8'b00111110;
  11'h5A2:cg8_rom = 8'b00001000;
  11'h5A3:cg8_rom = 8'b00001000;
  11'h5A4:cg8_rom = 8'b00001000;
  11'h5A5:cg8_rom = 8'b00001000;
  11'h5A6:cg8_rom = 8'b00111110;
  11'h5A7:cg8_rom = 8'b00000000;
// B5
  11'h5A8:cg8_rom = 8'b00000000;
  11'h5A9:cg8_rom = 8'b00001000;
  11'h5AA:cg8_rom = 8'b01111110;
  11'h5AB:cg8_rom = 8'b00001000;
  11'h5AC:cg8_rom = 8'b00011000;
  11'h5AD:cg8_rom = 8'b00101000;
  11'h5AE:cg8_rom = 8'b01001000;
  11'h5AF:cg8_rom = 8'b00000000;
// B6
  11'h5B0:cg8_rom = 8'b00000000;
  11'h5B1:cg8_rom = 8'b00010000;
  11'h5B2:cg8_rom = 8'b01111110;
  11'h5B3:cg8_rom = 8'b00010010;
  11'h5B4:cg8_rom = 8'b00010010;
  11'h5B5:cg8_rom = 8'b00100010;
  11'h5B6:cg8_rom = 8'b00100100;
  11'h5B7:cg8_rom = 8'b00000000;
// B7
  11'h5B8:cg8_rom = 8'b00000000;
  11'h5B9:cg8_rom = 8'b00001000;
  11'h5BA:cg8_rom = 8'b00111110;
  11'h5BB:cg8_rom = 8'b00001000;
  11'h5BC:cg8_rom = 8'b00111110;
  11'h5BD:cg8_rom = 8'b00001000;
  11'h5BE:cg8_rom = 8'b00001000;
  11'h5BF:cg8_rom = 8'b00000000;
// B8
  11'h5C0:cg8_rom = 8'b00000000;
  11'h5C1:cg8_rom = 8'b00011110;
  11'h5C2:cg8_rom = 8'b00100010;
  11'h5C3:cg8_rom = 8'b01000010;
  11'h5C4:cg8_rom = 8'b00000100;
  11'h5C5:cg8_rom = 8'b00001000;
  11'h5C6:cg8_rom = 8'b00110000;
  11'h5C7:cg8_rom = 8'b00000000;
// B9
  11'h5C8:cg8_rom = 8'b00000000;
  11'h5C9:cg8_rom = 8'b00100000;
  11'h5CA:cg8_rom = 8'b00111110;
  11'h5CB:cg8_rom = 8'b01001000;
  11'h5CC:cg8_rom = 8'b00001000;
  11'h5CD:cg8_rom = 8'b00001000;
  11'h5CE:cg8_rom = 8'b00010000;
  11'h5CF:cg8_rom = 8'b00000000;
// BA
  11'h5D0:cg8_rom = 8'b00000000;
  11'h5D1:cg8_rom = 8'b01111110;
  11'h5D2:cg8_rom = 8'b00000010;
  11'h5D3:cg8_rom = 8'b00000010;
  11'h5D4:cg8_rom = 8'b00000010;
  11'h5D5:cg8_rom = 8'b00000010;
  11'h5D6:cg8_rom = 8'b01111110;
  11'h5D7:cg8_rom = 8'b00000000;
// BB
  11'h5D8:cg8_rom = 8'b00000000;
  11'h5D9:cg8_rom = 8'b00100100;
  11'h5DA:cg8_rom = 8'b01111110;
  11'h5DB:cg8_rom = 8'b00100100;
  11'h5DC:cg8_rom = 8'b00000100;
  11'h5DD:cg8_rom = 8'b00000100;
  11'h5DE:cg8_rom = 8'b00011000;
  11'h5DF:cg8_rom = 8'b00000000;
// BC
  11'h5E0:cg8_rom = 8'b00000000;
  11'h5E1:cg8_rom = 8'b01110000;
  11'h5E2:cg8_rom = 8'b00000000;
  11'h5E3:cg8_rom = 8'b01110010;
  11'h5E4:cg8_rom = 8'b00000010;
  11'h5E5:cg8_rom = 8'b00000100;
  11'h5E6:cg8_rom = 8'b01111000;
  11'h5E7:cg8_rom = 8'b00000000;
// BD
  11'h5E8:cg8_rom = 8'b00000000;
  11'h5E9:cg8_rom = 8'b01111110;
  11'h5EA:cg8_rom = 8'b00000010;
  11'h5EB:cg8_rom = 8'b00000100;
  11'h5EC:cg8_rom = 8'b00001000;
  11'h5ED:cg8_rom = 8'b00010100;
  11'h5EE:cg8_rom = 8'b01100010;
  11'h5EF:cg8_rom = 8'b00000000;
// BE
  11'h5F0:cg8_rom = 8'b00000000;
  11'h5F1:cg8_rom = 8'b00100000;
  11'h5F2:cg8_rom = 8'b01111110;
  11'h5F3:cg8_rom = 8'b00100010;
  11'h5F4:cg8_rom = 8'b00100100;
  11'h5F5:cg8_rom = 8'b00100000;
  11'h5F6:cg8_rom = 8'b00011110;
  11'h5F7:cg8_rom = 8'b00000000;
// BF
  11'h5F8:cg8_rom = 8'b00000000;
  11'h5F9:cg8_rom = 8'b00100010;
  11'h5FA:cg8_rom = 8'b00100010;
  11'h5FB:cg8_rom = 8'b00010010;
  11'h5FC:cg8_rom = 8'b00000010;
  11'h5FD:cg8_rom = 8'b00000100;
  11'h5FE:cg8_rom = 8'b00011000;
  11'h5FF:cg8_rom = 8'b00000000;
// C0
  11'h600:cg8_rom = 8'b00000000;
  11'h601:cg8_rom = 8'b00011110;
  11'h602:cg8_rom = 8'b00010010;
  11'h603:cg8_rom = 8'b00101010;
  11'h604:cg8_rom = 8'b00000110;
  11'h605:cg8_rom = 8'b00000100;
  11'h606:cg8_rom = 8'b00011000;
  11'h607:cg8_rom = 8'b00000000;
// C1
  11'h608:cg8_rom = 8'b00000000;
  11'h609:cg8_rom = 8'b00111100;
  11'h60A:cg8_rom = 8'b00001000;
  11'h60B:cg8_rom = 8'b01111110;
  11'h60C:cg8_rom = 8'b00001000;
  11'h60D:cg8_rom = 8'b00001000;
  11'h60E:cg8_rom = 8'b00010000;
  11'h60F:cg8_rom = 8'b00000000;
// C2
  11'h610:cg8_rom = 8'b00000000;
  11'h611:cg8_rom = 8'b01010010;
  11'h612:cg8_rom = 8'b01010010;
  11'h613:cg8_rom = 8'b01010010;
  11'h614:cg8_rom = 8'b00000010;
  11'h615:cg8_rom = 8'b00000100;
  11'h616:cg8_rom = 8'b00011000;
  11'h617:cg8_rom = 8'b00000000;
// C3
  11'h618:cg8_rom = 8'b00000000;
  11'h619:cg8_rom = 8'b00111100;
  11'h61A:cg8_rom = 8'b00000000;
  11'h61B:cg8_rom = 8'b01111110;
  11'h61C:cg8_rom = 8'b00001000;
  11'h61D:cg8_rom = 8'b00001000;
  11'h61E:cg8_rom = 8'b00010000;
  11'h61F:cg8_rom = 8'b00000000;
// C4
  11'h620:cg8_rom = 8'b00000000;
  11'h621:cg8_rom = 8'b00010000;
  11'h622:cg8_rom = 8'b00010000;
  11'h623:cg8_rom = 8'b00011000;
  11'h624:cg8_rom = 8'b00010100;
  11'h625:cg8_rom = 8'b00010000;
  11'h626:cg8_rom = 8'b00010000;
  11'h627:cg8_rom = 8'b00000000;
// C5
  11'h628:cg8_rom = 8'b00000000;
  11'h629:cg8_rom = 8'b00001000;
  11'h62A:cg8_rom = 8'b01111110;
  11'h62B:cg8_rom = 8'b00001000;
  11'h62C:cg8_rom = 8'b00001000;
  11'h62D:cg8_rom = 8'b00010000;
  11'h62E:cg8_rom = 8'b00100000;
  11'h62F:cg8_rom = 8'b00000000;
// C6
  11'h630:cg8_rom = 8'b00000000;
  11'h631:cg8_rom = 8'b00111100;
  11'h632:cg8_rom = 8'b00000000;
  11'h633:cg8_rom = 8'b00000000;
  11'h634:cg8_rom = 8'b00000000;
  11'h635:cg8_rom = 8'b00000000;
  11'h636:cg8_rom = 8'b01111110;
  11'h637:cg8_rom = 8'b00000000;
// C7
  11'h638:cg8_rom = 8'b00000000;
  11'h639:cg8_rom = 8'b00111110;
  11'h63A:cg8_rom = 8'b00000010;
  11'h63B:cg8_rom = 8'b00010100;
  11'h63C:cg8_rom = 8'b00001000;
  11'h63D:cg8_rom = 8'b00010100;
  11'h63E:cg8_rom = 8'b00100000;
  11'h63F:cg8_rom = 8'b00000000;
// C8
  11'h640:cg8_rom = 8'b00000000;
  11'h641:cg8_rom = 8'b00001000;
  11'h642:cg8_rom = 8'b00111110;
  11'h643:cg8_rom = 8'b00000100;
  11'h644:cg8_rom = 8'b00011100;
  11'h645:cg8_rom = 8'b00101010;
  11'h646:cg8_rom = 8'b00001000;
  11'h647:cg8_rom = 8'b00000000;
// C9
  11'h648:cg8_rom = 8'b00000000;
  11'h649:cg8_rom = 8'b00000010;
  11'h64A:cg8_rom = 8'b00000010;
  11'h64B:cg8_rom = 8'b00000100;
  11'h64C:cg8_rom = 8'b00000100;
  11'h64D:cg8_rom = 8'b00001000;
  11'h64E:cg8_rom = 8'b00110000;
  11'h64F:cg8_rom = 8'b00000000;
// CA
  11'h650:cg8_rom = 8'b00000000;
  11'h651:cg8_rom = 8'b00001000;
  11'h652:cg8_rom = 8'b00100100;
  11'h653:cg8_rom = 8'b00100010;
  11'h654:cg8_rom = 8'b01000010;
  11'h655:cg8_rom = 8'b01000010;
  11'h656:cg8_rom = 8'b01000010;
  11'h657:cg8_rom = 8'b00000000;
// CB
  11'h658:cg8_rom = 8'b00000000;
  11'h659:cg8_rom = 8'b01000000;
  11'h65A:cg8_rom = 8'b01111110;
  11'h65B:cg8_rom = 8'b01000000;
  11'h65C:cg8_rom = 8'b01000000;
  11'h65D:cg8_rom = 8'b01000000;
  11'h65E:cg8_rom = 8'b00111110;
  11'h65F:cg8_rom = 8'b00000000;
// CC
  11'h660:cg8_rom = 8'b00000000;
  11'h661:cg8_rom = 8'b01111110;
  11'h662:cg8_rom = 8'b00000010;
  11'h663:cg8_rom = 8'b00000010;
  11'h664:cg8_rom = 8'b00000100;
  11'h665:cg8_rom = 8'b00001000;
  11'h666:cg8_rom = 8'b00110000;
  11'h667:cg8_rom = 8'b00000000;
// CD
  11'h668:cg8_rom = 8'b00000000;
  11'h669:cg8_rom = 8'b00000000;
  11'h66A:cg8_rom = 8'b00010000;
  11'h66B:cg8_rom = 8'b00101000;
  11'h66C:cg8_rom = 8'b01000100;
  11'h66D:cg8_rom = 8'b00000010;
  11'h66E:cg8_rom = 8'b00000000;
  11'h66F:cg8_rom = 8'b00000000;
// CE
  11'h670:cg8_rom = 8'b00000000;
  11'h671:cg8_rom = 8'b00001000;
  11'h672:cg8_rom = 8'b00111110;
  11'h673:cg8_rom = 8'b00001000;
  11'h674:cg8_rom = 8'b00101010;
  11'h675:cg8_rom = 8'b00101010;
  11'h676:cg8_rom = 8'b00001000;
  11'h677:cg8_rom = 8'b00000000;
// CF
  11'h678:cg8_rom = 8'b00000000;
  11'h679:cg8_rom = 8'b01111110;
  11'h67A:cg8_rom = 8'b00000010;
  11'h67B:cg8_rom = 8'b00000100;
  11'h67C:cg8_rom = 8'b00101000;
  11'h67D:cg8_rom = 8'b00010000;
  11'h67E:cg8_rom = 8'b00001000;
  11'h67F:cg8_rom = 8'b00000000;
// D0
  11'h680:cg8_rom = 8'b00000000;
  11'h681:cg8_rom = 8'b00111100;
  11'h682:cg8_rom = 8'b00000000;
  11'h683:cg8_rom = 8'b00111100;
  11'h684:cg8_rom = 8'b00000000;
  11'h685:cg8_rom = 8'b01111100;
  11'h686:cg8_rom = 8'b00000010;
  11'h687:cg8_rom = 8'b00000000;
// D1
  11'h688:cg8_rom = 8'b00000000;
  11'h689:cg8_rom = 8'b00010000;
  11'h68A:cg8_rom = 8'b00100000;
  11'h68B:cg8_rom = 8'b01000000;
  11'h68C:cg8_rom = 8'b01000100;
  11'h68D:cg8_rom = 8'b01111100;
  11'h68E:cg8_rom = 8'b00000010;
  11'h68F:cg8_rom = 8'b00000000;
// D2
  11'h690:cg8_rom = 8'b00000000;
  11'h691:cg8_rom = 8'b00000010;
  11'h692:cg8_rom = 8'b00000010;
  11'h693:cg8_rom = 8'b00010100;
  11'h694:cg8_rom = 8'b00001000;
  11'h695:cg8_rom = 8'b00010100;
  11'h696:cg8_rom = 8'b00100000;
  11'h697:cg8_rom = 8'b00000000;
// D3
  11'h698:cg8_rom = 8'b00000000;
  11'h699:cg8_rom = 8'b01111110;
  11'h69A:cg8_rom = 8'b00010000;
  11'h69B:cg8_rom = 8'b01111110;
  11'h69C:cg8_rom = 8'b00010000;
  11'h69D:cg8_rom = 8'b00010000;
  11'h69E:cg8_rom = 8'b00011110;
  11'h69F:cg8_rom = 8'b00000000;
// D4
  11'h6A0:cg8_rom = 8'b00100000;
  11'h6A1:cg8_rom = 8'b00100000;
  11'h6A2:cg8_rom = 8'b01111110;
  11'h6A3:cg8_rom = 8'b00100010;
  11'h6A4:cg8_rom = 8'b00100100;
  11'h6A5:cg8_rom = 8'b00100000;
  11'h6A6:cg8_rom = 8'b00100000;
  11'h6A7:cg8_rom = 8'b00000000;
// D5
  11'h6A8:cg8_rom = 8'b00000000;
  11'h6A9:cg8_rom = 8'b00111000;
  11'h6AA:cg8_rom = 8'b00001000;
  11'h6AB:cg8_rom = 8'b00001000;
  11'h6AC:cg8_rom = 8'b00001000;
  11'h6AD:cg8_rom = 8'b00001000;
  11'h6AE:cg8_rom = 8'b01111110;
  11'h6AF:cg8_rom = 8'b00000000;
// D6
  11'h6B0:cg8_rom = 8'b00000000;
  11'h6B1:cg8_rom = 8'b01111110;
  11'h6B2:cg8_rom = 8'b00000010;
  11'h6B3:cg8_rom = 8'b01111110;
  11'h6B4:cg8_rom = 8'b00000010;
  11'h6B5:cg8_rom = 8'b00000010;
  11'h6B6:cg8_rom = 8'b01111110;
  11'h6B7:cg8_rom = 8'b00000000;
// D7
  11'h6B8:cg8_rom = 8'b00000000;
  11'h6B9:cg8_rom = 8'b00111100;
  11'h6BA:cg8_rom = 8'b00000000;
  11'h6BB:cg8_rom = 8'b01111110;
  11'h6BC:cg8_rom = 8'b00000010;
  11'h6BD:cg8_rom = 8'b00000100;
  11'h6BE:cg8_rom = 8'b00111000;
  11'h6BF:cg8_rom = 8'b00000000;
// D8
  11'h6C0:cg8_rom = 8'b00000000;
  11'h6C1:cg8_rom = 8'b00100010;
  11'h6C2:cg8_rom = 8'b00100010;
  11'h6C3:cg8_rom = 8'b00100010;
  11'h6C4:cg8_rom = 8'b00000010;
  11'h6C5:cg8_rom = 8'b00000100;
  11'h6C6:cg8_rom = 8'b00011000;
  11'h6C7:cg8_rom = 8'b00000000;
// D9
  11'h6C8:cg8_rom = 8'b00000000;
  11'h6C9:cg8_rom = 8'b00101000;
  11'h6CA:cg8_rom = 8'b00101000;
  11'h6CB:cg8_rom = 8'b00101000;
  11'h6CC:cg8_rom = 8'b00101010;
  11'h6CD:cg8_rom = 8'b00101010;
  11'h6CE:cg8_rom = 8'b01001100;
  11'h6CF:cg8_rom = 8'b00000000;
// DA
  11'h6D0:cg8_rom = 8'b00000000;
  11'h6D1:cg8_rom = 8'b00100000;
  11'h6D2:cg8_rom = 8'b00100000;
  11'h6D3:cg8_rom = 8'b00100010;
  11'h6D4:cg8_rom = 8'b00100100;
  11'h6D5:cg8_rom = 8'b00101000;
  11'h6D6:cg8_rom = 8'b00110000;
  11'h6D7:cg8_rom = 8'b00000000;
// DB
  11'h6D8:cg8_rom = 8'b00000000;
  11'h6D9:cg8_rom = 8'b00111110;
  11'h6DA:cg8_rom = 8'b00100010;
  11'h6DB:cg8_rom = 8'b00100010;
  11'h6DC:cg8_rom = 8'b00100010;
  11'h6DD:cg8_rom = 8'b00100010;
  11'h6DE:cg8_rom = 8'b00111110;
  11'h6DF:cg8_rom = 8'b00000000;
// DC
  11'h6E0:cg8_rom = 8'b00000000;
  11'h6E1:cg8_rom = 8'b01111110;
  11'h6E2:cg8_rom = 8'b01000010;
  11'h6E3:cg8_rom = 8'b01000010;
  11'h6E4:cg8_rom = 8'b00000010;
  11'h6E5:cg8_rom = 8'b00000100;
  11'h6E6:cg8_rom = 8'b00011000;
  11'h6E7:cg8_rom = 8'b00000000;
// DD
  11'h6E8:cg8_rom = 8'b00000000;
  11'h6E9:cg8_rom = 8'b01110000;
  11'h6EA:cg8_rom = 8'b00000010;
  11'h6EB:cg8_rom = 8'b00000010;
  11'h6EC:cg8_rom = 8'b00000100;
  11'h6ED:cg8_rom = 8'b00001000;
  11'h6EE:cg8_rom = 8'b01110000;
  11'h6EF:cg8_rom = 8'b00000000;
// DE
  11'h6F0:cg8_rom = 8'b00010000;
  11'h6F1:cg8_rom = 8'b01001000;
  11'h6F2:cg8_rom = 8'b00100000;
  11'h6F3:cg8_rom = 8'b00000000;
  11'h6F4:cg8_rom = 8'b00000000;
  11'h6F5:cg8_rom = 8'b00000000;
  11'h6F6:cg8_rom = 8'b00000000;
  11'h6F7:cg8_rom = 8'b00000000;
// DF
  11'h6F8:cg8_rom = 8'b01110000;
  11'h6F9:cg8_rom = 8'b01010000;
  11'h6FA:cg8_rom = 8'b01110000;
  11'h6FB:cg8_rom = 8'b00000000;
  11'h6FC:cg8_rom = 8'b00000000;
  11'h6FD:cg8_rom = 8'b00000000;
  11'h6FE:cg8_rom = 8'b00000000;
  11'h6FF:cg8_rom = 8'b00000000;
// E0
  11'h700:cg8_rom = 8'b00000000;
  11'h701:cg8_rom = 8'b00111100;
  11'h702:cg8_rom = 8'b01111110;
  11'h703:cg8_rom = 8'b01111110;
  11'h704:cg8_rom = 8'b01111110;
  11'h705:cg8_rom = 8'b01111110;
  11'h706:cg8_rom = 8'b00111100;
  11'h707:cg8_rom = 8'b00000000;
// E1
  11'h708:cg8_rom = 8'b00000000;
  11'h709:cg8_rom = 8'b00111100;
  11'h70A:cg8_rom = 8'b01000010;
  11'h70B:cg8_rom = 8'b01000010;
  11'h70C:cg8_rom = 8'b01000010;
  11'h70D:cg8_rom = 8'b01000010;
  11'h70E:cg8_rom = 8'b00111100;
  11'h70F:cg8_rom = 8'b00000000;
// E2
  11'h710:cg8_rom = 8'b00010000;
  11'h711:cg8_rom = 8'b00111000;
  11'h712:cg8_rom = 8'b01111100;
  11'h713:cg8_rom = 8'b11111110;
  11'h714:cg8_rom = 8'b11111110;
  11'h715:cg8_rom = 8'b00111000;
  11'h716:cg8_rom = 8'b01111100;
  11'h717:cg8_rom = 8'b00000000;
// E3
  11'h718:cg8_rom = 8'b01101100;
  11'h719:cg8_rom = 8'b11111110;
  11'h71A:cg8_rom = 8'b11111110;
  11'h71B:cg8_rom = 8'b11111110;
  11'h71C:cg8_rom = 8'b01111100;
  11'h71D:cg8_rom = 8'b00111000;
  11'h71E:cg8_rom = 8'b00010000;
  11'h71F:cg8_rom = 8'b00000000;
// E4
  11'h720:cg8_rom = 8'b00010000;
  11'h721:cg8_rom = 8'b00111000;
  11'h722:cg8_rom = 8'b01111100;
  11'h723:cg8_rom = 8'b11111110;
  11'h724:cg8_rom = 8'b01111100;
  11'h725:cg8_rom = 8'b00111000;
  11'h726:cg8_rom = 8'b00010000;
  11'h727:cg8_rom = 8'b00000000;
// E5
  11'h728:cg8_rom = 8'b00111000;
  11'h729:cg8_rom = 8'b00111000;
  11'h72A:cg8_rom = 8'b11111110;
  11'h72B:cg8_rom = 8'b11111110;
  11'h72C:cg8_rom = 8'b11010110;
  11'h72D:cg8_rom = 8'b00010000;
  11'h72E:cg8_rom = 8'b01111100;
  11'h72F:cg8_rom = 8'b00000000;
// E6
  11'h730:cg8_rom = 8'b00000001;
  11'h731:cg8_rom = 8'b00000011;
  11'h732:cg8_rom = 8'b00000111;
  11'h733:cg8_rom = 8'b00001111;
  11'h734:cg8_rom = 8'b00011111;
  11'h735:cg8_rom = 8'b00111111;
  11'h736:cg8_rom = 8'b01111111;
  11'h737:cg8_rom = 8'b11111111;
// E7
  11'h738:cg8_rom = 8'b10000000;
  11'h739:cg8_rom = 8'b11000000;
  11'h73A:cg8_rom = 8'b11100000;
  11'h73B:cg8_rom = 8'b11110000;
  11'h73C:cg8_rom = 8'b11111000;
  11'h73D:cg8_rom = 8'b11111100;
  11'h73E:cg8_rom = 8'b11111110;
  11'h73F:cg8_rom = 8'b11111111;
// E8
  11'h740:cg8_rom = 8'b10000001;
  11'h741:cg8_rom = 8'b01000010;
  11'h742:cg8_rom = 8'b00100100;
  11'h743:cg8_rom = 8'b00011000;
  11'h744:cg8_rom = 8'b00011000;
  11'h745:cg8_rom = 8'b00100100;
  11'h746:cg8_rom = 8'b01000010;
  11'h747:cg8_rom = 8'b10000001;
// E9
  11'h748:cg8_rom = 8'b11110000;
  11'h749:cg8_rom = 8'b11110000;
  11'h74A:cg8_rom = 8'b11110000;
  11'h74B:cg8_rom = 8'b11110000;
  11'h74C:cg8_rom = 8'b00000000;
  11'h74D:cg8_rom = 8'b00000000;
  11'h74E:cg8_rom = 8'b00000000;
  11'h74F:cg8_rom = 8'b00000000;
// EA
  11'h750:cg8_rom = 8'b00000000;
  11'h751:cg8_rom = 8'b00000000;
  11'h752:cg8_rom = 8'b00000000;
  11'h753:cg8_rom = 8'b00000000;
  11'h754:cg8_rom = 8'b11110000;
  11'h755:cg8_rom = 8'b11110000;
  11'h756:cg8_rom = 8'b11110000;
  11'h757:cg8_rom = 8'b11110000;
// EB
  11'h758:cg8_rom = 8'b00001111;
  11'h759:cg8_rom = 8'b00001111;
  11'h75A:cg8_rom = 8'b00001111;
  11'h75B:cg8_rom = 8'b00001111;
  11'h75C:cg8_rom = 8'b00000000;
  11'h75D:cg8_rom = 8'b00000000;
  11'h75E:cg8_rom = 8'b00000000;
  11'h75F:cg8_rom = 8'b00000000;
// EC
  11'h760:cg8_rom = 8'b00000000;
  11'h761:cg8_rom = 8'b00000000;
  11'h762:cg8_rom = 8'b00000000;
  11'h763:cg8_rom = 8'b00000000;
  11'h764:cg8_rom = 8'b00001111;
  11'h765:cg8_rom = 8'b00001111;
  11'h766:cg8_rom = 8'b00001111;
  11'h767:cg8_rom = 8'b00001111;
// ED
  11'h768:cg8_rom = 8'b00001111;
  11'h769:cg8_rom = 8'b00001111;
  11'h76A:cg8_rom = 8'b00001111;
  11'h76B:cg8_rom = 8'b00001111;
  11'h76C:cg8_rom = 8'b11110000;
  11'h76D:cg8_rom = 8'b11110000;
  11'h76E:cg8_rom = 8'b11110000;
  11'h76F:cg8_rom = 8'b11110000;
// EE
  11'h770:cg8_rom = 8'b11110000;
  11'h771:cg8_rom = 8'b11110000;
  11'h772:cg8_rom = 8'b11110000;
  11'h773:cg8_rom = 8'b11110000;
  11'h774:cg8_rom = 8'b00001111;
  11'h775:cg8_rom = 8'b00001111;
  11'h776:cg8_rom = 8'b00001111;
  11'h777:cg8_rom = 8'b00001111;
// EF
  11'h778:cg8_rom = 8'b11111111;
  11'h779:cg8_rom = 8'b10000001;
  11'h77A:cg8_rom = 8'b10000001;
  11'h77B:cg8_rom = 8'b10000001;
  11'h77C:cg8_rom = 8'b10000001;
  11'h77D:cg8_rom = 8'b10000001;
  11'h77E:cg8_rom = 8'b10000001;
  11'h77F:cg8_rom = 8'b11111111;
// F0
  11'h780:cg8_rom = 8'b10101010;
  11'h781:cg8_rom = 8'b01010101;
  11'h782:cg8_rom = 8'b10101010;
  11'h783:cg8_rom = 8'b01010101;
  11'h784:cg8_rom = 8'b10101010;
  11'h785:cg8_rom = 8'b01010101;
  11'h786:cg8_rom = 8'b10101010;
  11'h787:cg8_rom = 8'b01010101;
// F1
  11'h788:cg8_rom = 8'b00010000;
  11'h789:cg8_rom = 8'b00010000;
  11'h78A:cg8_rom = 8'b01111100;
  11'h78B:cg8_rom = 8'b00010000;
  11'h78C:cg8_rom = 8'b00010000;
  11'h78D:cg8_rom = 8'b00010000;
  11'h78E:cg8_rom = 8'b11111110;
  11'h78F:cg8_rom = 8'b00000000;
// F2
  11'h790:cg8_rom = 8'b00111000;
  11'h791:cg8_rom = 8'b01000100;
  11'h792:cg8_rom = 8'b10111010;
  11'h793:cg8_rom = 8'b00010000;
  11'h794:cg8_rom = 8'b00111000;
  11'h795:cg8_rom = 8'b01010100;
  11'h796:cg8_rom = 8'b11111110;
  11'h797:cg8_rom = 8'b00000000;
// F3
  11'h798:cg8_rom = 8'b00010000;
  11'h799:cg8_rom = 8'b00010000;
  11'h79A:cg8_rom = 8'b11111110;
  11'h79B:cg8_rom = 8'b00010000;
  11'h79C:cg8_rom = 8'b00111000;
  11'h79D:cg8_rom = 8'b01010100;
  11'h79E:cg8_rom = 8'b10010010;
  11'h79F:cg8_rom = 8'b00000000;
// F4
  11'h7A0:cg8_rom = 8'b00010000;
  11'h7A1:cg8_rom = 8'b00010110;
  11'h7A2:cg8_rom = 8'b11111000;
  11'h7A3:cg8_rom = 8'b00111000;
  11'h7A4:cg8_rom = 8'b01010100;
  11'h7A5:cg8_rom = 8'b01010100;
  11'h7A6:cg8_rom = 8'b10110010;
  11'h7A7:cg8_rom = 8'b00000000;
// F5
  11'h7A8:cg8_rom = 8'b00010000;
  11'h7A9:cg8_rom = 8'b01010100;
  11'h7AA:cg8_rom = 8'b01010100;
  11'h7AB:cg8_rom = 8'b01010100;
  11'h7AC:cg8_rom = 8'b00010000;
  11'h7AD:cg8_rom = 8'b00101000;
  11'h7AE:cg8_rom = 8'b01000100;
  11'h7AF:cg8_rom = 8'b00000000;
// F6
  11'h7B0:cg8_rom = 8'b01111100;
  11'h7B1:cg8_rom = 8'b01000100;
  11'h7B2:cg8_rom = 8'b01111100;
  11'h7B3:cg8_rom = 8'b01000100;
  11'h7B4:cg8_rom = 8'b01111100;
  11'h7B5:cg8_rom = 8'b01000100;
  11'h7B6:cg8_rom = 8'b10001100;
  11'h7B7:cg8_rom = 8'b00000000;
// F7
  11'h7B8:cg8_rom = 8'b01111100;
  11'h7B9:cg8_rom = 8'b01000100;
  11'h7BA:cg8_rom = 8'b01000100;
  11'h7BB:cg8_rom = 8'b01111100;
  11'h7BC:cg8_rom = 8'b01000100;
  11'h7BD:cg8_rom = 8'b01000100;
  11'h7BE:cg8_rom = 8'b01111100;
  11'h7BF:cg8_rom = 8'b00000000;
// F8
  11'h7C0:cg8_rom = 8'b00001000;
  11'h7C1:cg8_rom = 8'b11111100;
  11'h7C2:cg8_rom = 8'b10101000;
  11'h7C3:cg8_rom = 8'b11111110;
  11'h7C4:cg8_rom = 8'b10100100;
  11'h7C5:cg8_rom = 8'b11111110;
  11'h7C6:cg8_rom = 8'b00010100;
  11'h7C7:cg8_rom = 8'b00000000;
// F9
  11'h7C8:cg8_rom = 8'b00111000;
  11'h7C9:cg8_rom = 8'b01000100;
  11'h7CA:cg8_rom = 8'b10000010;
  11'h7CB:cg8_rom = 8'b01111100;
  11'h7CC:cg8_rom = 8'b00100100;
  11'h7CD:cg8_rom = 8'b00100100;
  11'h7CE:cg8_rom = 8'b01001100;
  11'h7CF:cg8_rom = 8'b00000000;
// FA
  11'h7D0:cg8_rom = 8'b01110100;
  11'h7D1:cg8_rom = 8'b00100100;
  11'h7D2:cg8_rom = 8'b11111110;
  11'h7D3:cg8_rom = 8'b00101110;
  11'h7D4:cg8_rom = 8'b01110110;
  11'h7D5:cg8_rom = 8'b10100100;
  11'h7D6:cg8_rom = 8'b00101000;
  11'h7D7:cg8_rom = 8'b00000000;
// FB
  11'h7D8:cg8_rom = 8'b00100000;
  11'h7D9:cg8_rom = 8'b01111100;
  11'h7DA:cg8_rom = 8'b10010000;
  11'h7DB:cg8_rom = 8'b01111100;
  11'h7DC:cg8_rom = 8'b01010000;
  11'h7DD:cg8_rom = 8'b11111100;
  11'h7DE:cg8_rom = 8'b00010000;
  11'h7DF:cg8_rom = 8'b00000000;
// FC
  11'h7E0:cg8_rom = 8'b11111110;
  11'h7E1:cg8_rom = 8'b10010010;
  11'h7E2:cg8_rom = 8'b10010010;
  11'h7E3:cg8_rom = 8'b11111110;
  11'h7E4:cg8_rom = 8'b10000010;
  11'h7E5:cg8_rom = 8'b10000010;
  11'h7E6:cg8_rom = 8'b10000110;
  11'h7E7:cg8_rom = 8'b00000000;
// FD
  11'h7E8:cg8_rom = 8'b00010000;
  11'h7E9:cg8_rom = 8'b00010000;
  11'h7EA:cg8_rom = 8'b00010000;
  11'h7EB:cg8_rom = 8'b00010000;
  11'h7EC:cg8_rom = 8'b00101000;
  11'h7ED:cg8_rom = 8'b00101000;
  11'h7EE:cg8_rom = 8'b11000110;
  11'h7EF:cg8_rom = 8'b00000000;
// FE
  11'h7F0:cg8_rom = 8'b00010000;
  11'h7F1:cg8_rom = 8'b10010000;
  11'h7F2:cg8_rom = 8'b11111100;
  11'h7F3:cg8_rom = 8'b10010000;
  11'h7F4:cg8_rom = 8'b00111100;
  11'h7F5:cg8_rom = 8'b00010000;
  11'h7F6:cg8_rom = 8'b11111110;
  11'h7F7:cg8_rom = 8'b00000000;
// FF
  11'h7F8:cg8_rom = 8'b00000000;
  11'h7F9:cg8_rom = 8'b01111100;
  11'h7FA:cg8_rom = 8'b00000000;
  11'h7FB:cg8_rom = 8'b11111110;
  11'h7FC:cg8_rom = 8'b00010000;
  11'h7FD:cg8_rom = 8'b00010000;
  11'h7FE:cg8_rom = 8'b00010000;
  11'h7FF:cg8_rom = 8'b00000000;
  endcase
end
endfunction

always @(posedge I_CLK) O_DATA <= cg8_rom(I_ADDR);

endmodule

