
/////////////////////////////////////////////////////////////////////////////
// nbit x nbit GenericDualPort RAM
/////////////////////////////////////////////////////////////////////////////

module dpram2k8(
// CPU I/F
  ACLK,AA,AI,AO,ACS,AWE,
  BCLK,BA,BI,BO,BCS,BWE
);

input  ACLK,BCLK;
input  [10:0] AA,BA;
input  [7:0] AI,BI;
output [7:0] AO,BO;
input  ACS,BCS,AWE,BWE;

   RAMB16_S9_S9 RAMB16_S9_S9_inst (
      .DOA(AO),      // Port A 8-bit Data Output
      .DOB(BO),      // Port B 8-bit Data Output
      .DOPA(DOPA),    // Port A 1-bit Parity Output
      .DOPB(DOPB),    // Port B 1-bit Parity Output
      .ADDRA(AA),  // Port A 11-bit Address Input
      .ADDRB(BA),  // Port B 11-bit Address Input
      .CLKA(ACLK),    // Port A Clock
      .CLKB(BCLK),    // Port B Clock
      .DIA(AI),      // Port A 8-bit Data Input
      .DIB(BI),      // Port B 8-bit Data Input
      .DIPA(1'b0),    // Port A 1-bit parity Input
      .DIPB(1'b0),    // Port-B 1-bit parity Input
      .ENA(ACS),      // Port A RAM Enable Input
      .ENB(BCS),      // PortB RAM Enable Input
      .SSRA(1'b0),    // Port A Synchronous Set/Reset Input
      .SSRB(1'b0),    // Port B Synchronous Set/Reset Input
      .WEA(AWE),      // Port A Write Enable Input
      .WEB(BWE)       // Port B Write Enable Input
   );

   // The following defparam declarations are only necessary if you wish to change the default behavior
   // of the RAM. If the instance name is changed, these defparams need to be updated accordingly.

   defparam RAMB16_S9_S9_inst.INIT_A = 18'h0; // Value of output RAM registers on Port A at startup
   defparam RAMB16_S9_S9_inst.INIT_B = 18'h0; // Value of output RAM registers on Port B at startup
   defparam RAMB16_S9_S9_inst.SRVAL_A = 18'h0; // Port A ouput value upon SSR assertion
   defparam RAMB16_S9_S9_inst.SRVAL_B = 18'h0; // Port B ouput value upon SSR assertion
   defparam RAMB16_S9_S9_inst.WRITE_MODE_A = "WRITE_FIRST"; // WRITE_FIRST, READ_FIRST or NO_CHANGE
   defparam RAMB16_S9_S9_inst.WRITE_MODE_B = "WRITE_FIRST"; // WRITE_FIRST, READ_FIRST or NO_CHANGE

   // The following defparam INIT_xx declarations are only necessary if you wish to change the initial
   // contents of the RAM to anything other than all zero's.

   defparam RAMB16_S9_S9_inst.INIT_00 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_01 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_02 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_03 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_04 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_05 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_06 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_07 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_08 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_09 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_0A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_0B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_0C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_0D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_0E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_0F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_10 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_11 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_12 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_13 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_14 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_15 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_16 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_17 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_18 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_19 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_1A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_1B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_1C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_1D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_1E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_1F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_20 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_21 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_22 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_23 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_24 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_25 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_26 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_27 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_28 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_29 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_2A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_2B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_2C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_2D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_2E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_2F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_30 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_31 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_32 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_33 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_34 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_35 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_36 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_37 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_38 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_39 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_3A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_3B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_3C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_3D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_3E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INIT_3F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   // The next set of INITP_xx are for the parity bits
   defparam RAMB16_S9_S9_inst.INITP_00 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INITP_01 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INITP_02 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INITP_03 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INITP_04 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INITP_05 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INITP_06 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   defparam RAMB16_S9_S9_inst.INITP_07 = 256'h0000000000000000000000000000000000000000000000000000000000000000;

   // End of RAMB16_S9_S9_inst instantiation

endmodule
