//
// 2KB ROM
//
module bootrom(
  CLK,
  A,
  DO
);

input  CLK;
input  [10:0] A;
output [7:0] DO;

function [7:0] boot_rom ;
input [10:0] addr;
begin
case(addr)
  11'h0:boot_rom=8'h32;
  11'h1:boot_rom=8'h5F;
  11'h2:boot_rom=8'h40;
  11'h3:boot_rom=8'h3E;
  11'h4:boot_rom=8'h01;
  11'h5:boot_rom=8'hC3;
  11'h6:boot_rom=8'h00;
  11'h7:boot_rom=8'h01;
  11'h8:boot_rom=8'hC3;
  11'h9:boot_rom=8'hB5;
  11'hA:boot_rom=8'h03;
  11'hB:boot_rom=8'h3A;
  11'hC:boot_rom=8'h00;
  11'hD:boot_rom=8'hC0;
  11'hE:boot_rom=8'hCB;
  11'hF:boot_rom=8'h47;
  11'h10:boot_rom=8'h28;
  11'h11:boot_rom=8'h13;
  11'h12:boot_rom=8'hAF;
  11'h13:boot_rom=8'hC9;
  11'h14:boot_rom=8'hD9;
  11'h15:boot_rom=8'h11;
  11'h16:boot_rom=8'h00;
  11'h17:boot_rom=8'h00;
  11'h18:boot_rom=8'h1B;
  11'h19:boot_rom=8'h7A;
  11'h1A:boot_rom=8'hB3;
  11'h1B:boot_rom=8'h28;
  11'h1C:boot_rom=8'h08;
  11'h1D:boot_rom=8'hCB;
  11'h1E:boot_rom=8'h46;
  11'h1F:boot_rom=8'h28;
  11'h20:boot_rom=8'hF7;
  11'h21:boot_rom=8'hAF;
  11'h22:boot_rom=8'h0A;
  11'h23:boot_rom=8'hD9;
  11'h24:boot_rom=8'hC9;
  11'h25:boot_rom=8'h37;
  11'h26:boot_rom=8'hD9;
  11'h27:boot_rom=8'hC9;
  11'h28:boot_rom=8'hD9;
  11'h29:boot_rom=8'hCB;
  11'h2A:boot_rom=8'h56;
  11'h2B:boot_rom=8'h28;
  11'h2C:boot_rom=8'hFC;
  11'h2D:boot_rom=8'h02;
  11'h2E:boot_rom=8'hD9;
  11'h2F:boot_rom=8'hC9;
  11'h30:boot_rom=8'hFF;
  11'h31:boot_rom=8'hFF;
  11'h32:boot_rom=8'hFF;
  11'h33:boot_rom=8'hFF;
  11'h34:boot_rom=8'hFF;
  11'h35:boot_rom=8'hFF;
  11'h36:boot_rom=8'hFF;
  11'h37:boot_rom=8'hFF;
  11'h38:boot_rom=8'hFF;
  11'h39:boot_rom=8'hFF;
  11'h3A:boot_rom=8'hFF;
  11'h3B:boot_rom=8'hFF;
  11'h3C:boot_rom=8'hFF;
  11'h3D:boot_rom=8'hFF;
  11'h3E:boot_rom=8'hFF;
  11'h3F:boot_rom=8'hFF;
  11'h40:boot_rom=8'hFF;
  11'h41:boot_rom=8'hFF;
  11'h42:boot_rom=8'hFF;
  11'h43:boot_rom=8'hFF;
  11'h44:boot_rom=8'hFF;
  11'h45:boot_rom=8'hFF;
  11'h46:boot_rom=8'hFF;
  11'h47:boot_rom=8'hFF;
  11'h48:boot_rom=8'hFF;
  11'h49:boot_rom=8'hFF;
  11'h4A:boot_rom=8'hFF;
  11'h4B:boot_rom=8'hFF;
  11'h4C:boot_rom=8'hFF;
  11'h4D:boot_rom=8'hFF;
  11'h4E:boot_rom=8'hFF;
  11'h4F:boot_rom=8'hFF;
  11'h50:boot_rom=8'hFF;
  11'h51:boot_rom=8'hFF;
  11'h52:boot_rom=8'hFF;
  11'h53:boot_rom=8'hFF;
  11'h54:boot_rom=8'hFF;
  11'h55:boot_rom=8'hFF;
  11'h56:boot_rom=8'hFF;
  11'h57:boot_rom=8'hFF;
  11'h58:boot_rom=8'hFF;
  11'h59:boot_rom=8'hFF;
  11'h5A:boot_rom=8'hFF;
  11'h5B:boot_rom=8'hFF;
  11'h5C:boot_rom=8'hFF;
  11'h5D:boot_rom=8'hFF;
  11'h5E:boot_rom=8'hFF;
  11'h5F:boot_rom=8'hFF;
  11'h60:boot_rom=8'hFF;
  11'h61:boot_rom=8'hFF;
  11'h62:boot_rom=8'hFF;
  11'h63:boot_rom=8'hFF;
  11'h64:boot_rom=8'hFF;
  11'h65:boot_rom=8'hFF;
  11'h66:boot_rom=8'h32;
  11'h67:boot_rom=8'h5F;
  11'h68:boot_rom=8'h40;
  11'h69:boot_rom=8'h3E;
  11'h6A:boot_rom=8'h02;
  11'h6B:boot_rom=8'hC3;
  11'h6C:boot_rom=8'h00;
  11'h6D:boot_rom=8'h01;
  11'h6E:boot_rom=8'h31;
  11'h6F:boot_rom=8'h50;
  11'h70:boot_rom=8'h40;
  11'h71:boot_rom=8'h21;
  11'h72:boot_rom=8'h0A;
  11'h73:boot_rom=8'h07;
  11'h74:boot_rom=8'hCD;
  11'h75:boot_rom=8'hEC;
  11'h76:boot_rom=8'h06;
  11'h77:boot_rom=8'hCD;
  11'h78:boot_rom=8'h19;
  11'h79:boot_rom=8'h07;
  11'h7A:boot_rom=8'h3E;
  11'h7B:boot_rom=8'h07;
  11'h7C:boot_rom=8'h32;
  11'h7D:boot_rom=8'hFF;
  11'h7E:boot_rom=8'h40;
  11'h7F:boot_rom=8'h3E;
  11'h80:boot_rom=8'h0E;
  11'h81:boot_rom=8'h32;
  11'h82:boot_rom=8'h00;
  11'h83:boot_rom=8'hC0;
  11'h84:boot_rom=8'h21;
  11'h85:boot_rom=8'h66;
  11'h86:boot_rom=8'h06;
  11'h87:boot_rom=8'h11;
  11'h88:boot_rom=8'h00;
  11'h89:boot_rom=8'h00;
  11'h8A:boot_rom=8'h01;
  11'h8B:boot_rom=8'hEE;
  11'h8C:boot_rom=8'h00;
  11'h8D:boot_rom=8'hCD;
  11'h8E:boot_rom=8'hCC;
  11'h8F:boot_rom=8'h00;
  11'h90:boot_rom=8'h21;
  11'h91:boot_rom=8'h54;
  11'h92:boot_rom=8'h07;
  11'h93:boot_rom=8'h11;
  11'h94:boot_rom=8'h1A;
  11'h95:boot_rom=8'h02;
  11'h96:boot_rom=8'h01;
  11'h97:boot_rom=8'hA7;
  11'h98:boot_rom=8'h00;
  11'h99:boot_rom=8'hCD;
  11'h9A:boot_rom=8'hCC;
  11'h9B:boot_rom=8'h00;
  11'h9C:boot_rom=8'h3A;
  11'h9D:boot_rom=8'h00;
  11'h9E:boot_rom=8'hC0;
  11'h9F:boot_rom=8'hCB;
  11'hA0:boot_rom=8'h4F;
  11'hA1:boot_rom=8'hCA;
  11'hA2:boot_rom=8'h1C;
  11'hA3:boot_rom=8'h04;
  11'hA4:boot_rom=8'h21;
  11'hA5:boot_rom=8'hE1;
  11'hA6:boot_rom=8'h00;
  11'hA7:boot_rom=8'h01;
  11'hA8:boot_rom=8'h00;
  11'hA9:boot_rom=8'h30;
  11'hAA:boot_rom=8'hCD;
  11'hAB:boot_rom=8'hB9;
  11'hAC:boot_rom=8'h03;
  11'hAD:boot_rom=8'h21;
  11'hAE:boot_rom=8'h50;
  11'hAF:boot_rom=8'h40;
  11'hB0:boot_rom=8'h11;
  11'hB1:boot_rom=8'h51;
  11'hB2:boot_rom=8'h40;
  11'hB3:boot_rom=8'h01;
  11'hB4:boot_rom=8'h1B;
  11'hB5:boot_rom=8'h00;
  11'hB6:boot_rom=8'h36;
  11'hB7:boot_rom=8'h00;
  11'hB8:boot_rom=8'hED;
  11'hB9:boot_rom=8'hB0;
  11'hBA:boot_rom=8'hAF;
  11'hBB:boot_rom=8'h32;
  11'hBC:boot_rom=8'h50;
  11'hBD:boot_rom=8'h40;
  11'hBE:boot_rom=8'h32;
  11'hBF:boot_rom=8'h51;
  11'hC0:boot_rom=8'h40;
  11'hC1:boot_rom=8'h32;
  11'hC2:boot_rom=8'h00;
  11'hC3:boot_rom=8'hC0;
  11'hC4:boot_rom=8'h3E;
  11'hC5:boot_rom=8'hFA;
  11'hC6:boot_rom=8'h32;
  11'hC7:boot_rom=8'h6C;
  11'hC8:boot_rom=8'h40;
  11'hC9:boot_rom=8'hC3;
  11'hCA:boot_rom=8'h48;
  11'hCB:boot_rom=8'h02;
  11'hCC:boot_rom=8'h7E;
  11'hCD:boot_rom=8'hCD;
  11'hCE:boot_rom=8'h65;
  11'hCF:boot_rom=8'h11;
  11'hD0:boot_rom=8'h23;
  11'hD1:boot_rom=8'h13;
  11'hD2:boot_rom=8'h0B;
  11'hD3:boot_rom=8'h78;
  11'hD4:boot_rom=8'hB1;
  11'hD5:boot_rom=8'h20;
  11'hD6:boot_rom=8'hF5;
  11'hD7:boot_rom=8'hC9;
  11'hD8:boot_rom=8'h00;
  11'hD9:boot_rom=8'h90;
  11'hDA:boot_rom=8'h00;
  11'hDB:boot_rom=8'h00;
  11'hDC:boot_rom=8'h00;
  11'hDD:boot_rom=8'hFF;
  11'hDE:boot_rom=8'hFF;
  11'hDF:boot_rom=8'h01;
  11'hE0:boot_rom=8'hC7;
  11'hE1:boot_rom=8'h4E;
  11'hE2:boot_rom=8'h6F;
  11'hE3:boot_rom=8'h49;
  11'hE4:boot_rom=8'h43;
  11'hE5:boot_rom=8'h45;
  11'hE6:boot_rom=8'h20;
  11'hE7:boot_rom=8'h6D;
  11'hE8:boot_rom=8'h6F;
  11'hE9:boot_rom=8'h6E;
  11'hEA:boot_rom=8'h69;
  11'hEB:boot_rom=8'h74;
  11'hEC:boot_rom=8'h6F;
  11'hED:boot_rom=8'h72;
  11'hEE:boot_rom=8'h20;
  11'hEF:boot_rom=8'h56;
  11'hF0:boot_rom=8'h33;
  11'hF1:boot_rom=8'h2E;
  11'hF2:boot_rom=8'h30;
  11'hF3:boot_rom=8'h20;
  11'hF4:boot_rom=8'h66;
  11'hF5:boot_rom=8'h6F;
  11'hF6:boot_rom=8'h72;
  11'hF7:boot_rom=8'h20;
  11'hF8:boot_rom=8'h4E;
  11'hF9:boot_rom=8'h49;
  11'hFA:boot_rom=8'h53;
  11'hFB:boot_rom=8'h45;
  11'hFC:boot_rom=8'h2D;
  11'hFD:boot_rom=8'h58;
  11'hFE:boot_rom=8'h31;
  11'hFF:boot_rom=8'h00;
  11'h100:boot_rom=8'h32;
  11'h101:boot_rom=8'h50;
  11'h102:boot_rom=8'h40;
  11'h103:boot_rom=8'h3A;
  11'h104:boot_rom=8'h5F;
  11'h105:boot_rom=8'h40;
  11'h106:boot_rom=8'hED;
  11'h107:boot_rom=8'h73;
  11'h108:boot_rom=8'h52;
  11'h109:boot_rom=8'h40;
  11'h10A:boot_rom=8'h31;
  11'h10B:boot_rom=8'h6C;
  11'h10C:boot_rom=8'h40;
  11'h10D:boot_rom=8'h08;
  11'h10E:boot_rom=8'hD9;
  11'h10F:boot_rom=8'hF5;
  11'h110:boot_rom=8'hD5;
  11'h111:boot_rom=8'hC5;
  11'h112:boot_rom=8'hE5;
  11'h113:boot_rom=8'hED;
  11'h114:boot_rom=8'h57;
  11'h115:boot_rom=8'h6F;
  11'h116:boot_rom=8'h26;
  11'h117:boot_rom=8'h00;
  11'h118:boot_rom=8'hE2;
  11'h119:boot_rom=8'h1C;
  11'h11A:boot_rom=8'h01;
  11'h11B:boot_rom=8'h24;
  11'h11C:boot_rom=8'hE5;
  11'h11D:boot_rom=8'hE5;
  11'h11E:boot_rom=8'hD9;
  11'h11F:boot_rom=8'h08;
  11'h120:boot_rom=8'hF5;
  11'h121:boot_rom=8'hD5;
  11'h122:boot_rom=8'hC5;
  11'h123:boot_rom=8'hE5;
  11'h124:boot_rom=8'hFD;
  11'h125:boot_rom=8'hE5;
  11'h126:boot_rom=8'hDD;
  11'h127:boot_rom=8'hE5;
  11'h128:boot_rom=8'h31;
  11'h129:boot_rom=8'h50;
  11'h12A:boot_rom=8'h40;
  11'h12B:boot_rom=8'hFD;
  11'h12C:boot_rom=8'h21;
  11'h12D:boot_rom=8'h24;
  11'h12E:boot_rom=8'h00;
  11'h12F:boot_rom=8'hD9;
  11'h130:boot_rom=8'h21;
  11'h131:boot_rom=8'h00;
  11'h132:boot_rom=8'hC0;
  11'h133:boot_rom=8'h01;
  11'h134:boot_rom=8'h00;
  11'h135:boot_rom=8'h80;
  11'h136:boot_rom=8'hD9;
  11'h137:boot_rom=8'hAF;
  11'h138:boot_rom=8'h32;
  11'h139:boot_rom=8'h00;
  11'h13A:boot_rom=8'hC0;
  11'h13B:boot_rom=8'h2A;
  11'h13C:boot_rom=8'h52;
  11'h13D:boot_rom=8'h40;
  11'h13E:boot_rom=8'hCD;
  11'h13F:boot_rom=8'h68;
  11'h140:boot_rom=8'h11;
  11'h141:boot_rom=8'h23;
  11'h142:boot_rom=8'h5F;
  11'h143:boot_rom=8'hCD;
  11'h144:boot_rom=8'h68;
  11'h145:boot_rom=8'h11;
  11'h146:boot_rom=8'h23;
  11'h147:boot_rom=8'h57;
  11'h148:boot_rom=8'h22;
  11'h149:boot_rom=8'h52;
  11'h14A:boot_rom=8'h40;
  11'h14B:boot_rom=8'h3A;
  11'h14C:boot_rom=8'h50;
  11'h14D:boot_rom=8'h40;
  11'h14E:boot_rom=8'hFE;
  11'h14F:boot_rom=8'h01;
  11'h150:boot_rom=8'h20;
  11'h151:boot_rom=8'h09;
  11'h152:boot_rom=8'h1B;
  11'h153:boot_rom=8'h3A;
  11'h154:boot_rom=8'h00;
  11'h155:boot_rom=8'hC0;
  11'h156:boot_rom=8'hCB;
  11'h157:boot_rom=8'h7F;
  11'h158:boot_rom=8'hC2;
  11'h159:boot_rom=8'h6E;
  11'h15A:boot_rom=8'h00;
  11'h15B:boot_rom=8'hED;
  11'h15C:boot_rom=8'h53;
  11'h15D:boot_rom=8'h60;
  11'h15E:boot_rom=8'h40;
  11'h15F:boot_rom=8'hC3;
  11'h160:boot_rom=8'h48;
  11'h161:boot_rom=8'h02;
  11'h162:boot_rom=8'h1A;
  11'h163:boot_rom=8'hFD;
  11'h164:boot_rom=8'hE9;
  11'h165:boot_rom=8'h12;
  11'h166:boot_rom=8'hFD;
  11'h167:boot_rom=8'hE9;
  11'h168:boot_rom=8'h7E;
  11'h169:boot_rom=8'hFD;
  11'h16A:boot_rom=8'hE9;
  11'h16B:boot_rom=8'hE5;
  11'h16C:boot_rom=8'hFD;
  11'h16D:boot_rom=8'hE9;
  11'h16E:boot_rom=8'hE1;
  11'h16F:boot_rom=8'hFD;
  11'h170:boot_rom=8'hE9;
  11'h171:boot_rom=8'h31;
  11'h172:boot_rom=8'h50;
  11'h173:boot_rom=8'h40;
  11'h174:boot_rom=8'h21;
  11'h175:boot_rom=8'h6C;
  11'h176:boot_rom=8'h40;
  11'h177:boot_rom=8'hCD;
  11'h178:boot_rom=8'h14;
  11'h179:boot_rom=8'h00;
  11'h17A:boot_rom=8'h38;
  11'h17B:boot_rom=8'hF5;
  11'h17C:boot_rom=8'hFE;
  11'h17D:boot_rom=8'hF0;
  11'h17E:boot_rom=8'h38;
  11'h17F:boot_rom=8'hF1;
  11'h180:boot_rom=8'h77;
  11'h181:boot_rom=8'h23;
  11'h182:boot_rom=8'hCD;
  11'h183:boot_rom=8'h14;
  11'h184:boot_rom=8'h00;
  11'h185:boot_rom=8'h38;
  11'h186:boot_rom=8'hEA;
  11'h187:boot_rom=8'hFE;
  11'h188:boot_rom=8'h91;
  11'h189:boot_rom=8'h30;
  11'h18A:boot_rom=8'hE6;
  11'h18B:boot_rom=8'h77;
  11'h18C:boot_rom=8'h23;
  11'h18D:boot_rom=8'hB7;
  11'h18E:boot_rom=8'h28;
  11'h18F:boot_rom=8'h0A;
  11'h190:boot_rom=8'h47;
  11'h191:boot_rom=8'hCD;
  11'h192:boot_rom=8'h14;
  11'h193:boot_rom=8'h00;
  11'h194:boot_rom=8'h38;
  11'h195:boot_rom=8'hDB;
  11'h196:boot_rom=8'h77;
  11'h197:boot_rom=8'h23;
  11'h198:boot_rom=8'h10;
  11'h199:boot_rom=8'hF7;
  11'h19A:boot_rom=8'hCD;
  11'h19B:boot_rom=8'h14;
  11'h19C:boot_rom=8'h00;
  11'h19D:boot_rom=8'h38;
  11'h19E:boot_rom=8'hD2;
  11'h19F:boot_rom=8'h4F;
  11'h1A0:boot_rom=8'hCD;
  11'h1A1:boot_rom=8'h21;
  11'h1A2:boot_rom=8'h03;
  11'h1A3:boot_rom=8'h81;
  11'h1A4:boot_rom=8'h20;
  11'h1A5:boot_rom=8'hCB;
  11'h1A6:boot_rom=8'h3A;
  11'h1A7:boot_rom=8'h6C;
  11'h1A8:boot_rom=8'h40;
  11'h1A9:boot_rom=8'h2F;
  11'h1AA:boot_rom=8'h87;
  11'h1AB:boot_rom=8'hC6;
  11'h1AC:boot_rom=8'hBF;
  11'h1AD:boot_rom=8'h6F;
  11'h1AE:boot_rom=8'h26;
  11'h1AF:boot_rom=8'h01;
  11'h1B0:boot_rom=8'h7E;
  11'h1B1:boot_rom=8'h23;
  11'h1B2:boot_rom=8'h66;
  11'h1B3:boot_rom=8'h6F;
  11'h1B4:boot_rom=8'hE9;
  11'h1B5:boot_rom=8'h3E;
  11'h1B6:boot_rom=8'hF0;
  11'h1B7:boot_rom=8'h32;
  11'h1B8:boot_rom=8'h6C;
  11'h1B9:boot_rom=8'h40;
  11'h1BA:boot_rom=8'h3E;
  11'h1BB:boot_rom=8'h01;
  11'h1BC:boot_rom=8'hC3;
  11'h1BD:boot_rom=8'hFE;
  11'h1BE:boot_rom=8'h02;
  11'h1BF:boot_rom=8'hDF;
  11'h1C0:boot_rom=8'h01;
  11'h1C1:boot_rom=8'hF0;
  11'h1C2:boot_rom=8'h01;
  11'h1C3:boot_rom=8'h10;
  11'h1C4:boot_rom=8'h02;
  11'h1C5:boot_rom=8'h48;
  11'h1C6:boot_rom=8'h02;
  11'h1C7:boot_rom=8'h5C;
  11'h1C8:boot_rom=8'h02;
  11'h1C9:boot_rom=8'h73;
  11'h1CA:boot_rom=8'h02;
  11'h1CB:boot_rom=8'hB1;
  11'h1CC:boot_rom=8'h02;
  11'h1CD:boot_rom=8'hE8;
  11'h1CE:boot_rom=8'h02;
  11'h1CF:boot_rom=8'hF1;
  11'h1D0:boot_rom=8'h02;
  11'h1D1:boot_rom=8'hB5;
  11'h1D2:boot_rom=8'h01;
  11'h1D3:boot_rom=8'hB5;
  11'h1D4:boot_rom=8'h01;
  11'h1D5:boot_rom=8'hB5;
  11'h1D6:boot_rom=8'h01;
  11'h1D7:boot_rom=8'hB5;
  11'h1D8:boot_rom=8'h01;
  11'h1D9:boot_rom=8'hB5;
  11'h1DA:boot_rom=8'h01;
  11'h1DB:boot_rom=8'hB5;
  11'h1DC:boot_rom=8'h01;
  11'h1DD:boot_rom=8'hB5;
  11'h1DE:boot_rom=8'h01;
  11'h1DF:boot_rom=8'h21;
  11'h1E0:boot_rom=8'hD8;
  11'h1E1:boot_rom=8'h00;
  11'h1E2:boot_rom=8'h11;
  11'h1E3:boot_rom=8'h6D;
  11'h1E4:boot_rom=8'h40;
  11'h1E5:boot_rom=8'h01;
  11'h1E6:boot_rom=8'h28;
  11'h1E7:boot_rom=8'h00;
  11'h1E8:boot_rom=8'h79;
  11'h1E9:boot_rom=8'h12;
  11'h1EA:boot_rom=8'h13;
  11'h1EB:boot_rom=8'hED;
  11'h1EC:boot_rom=8'hB0;
  11'h1ED:boot_rom=8'hC3;
  11'h1EE:boot_rom=8'h08;
  11'h1EF:boot_rom=8'h03;
  11'h1F0:boot_rom=8'h3A;
  11'h1F1:boot_rom=8'h6E;
  11'h1F2:boot_rom=8'h40;
  11'h1F3:boot_rom=8'h32;
  11'h1F4:boot_rom=8'h00;
  11'h1F5:boot_rom=8'hC0;
  11'h1F6:boot_rom=8'h2A;
  11'h1F7:boot_rom=8'h6F;
  11'h1F8:boot_rom=8'h40;
  11'h1F9:boot_rom=8'h3A;
  11'h1FA:boot_rom=8'h71;
  11'h1FB:boot_rom=8'h40;
  11'h1FC:boot_rom=8'h11;
  11'h1FD:boot_rom=8'h6D;
  11'h1FE:boot_rom=8'h40;
  11'h1FF:boot_rom=8'h12;
  11'h200:boot_rom=8'h13;
  11'h201:boot_rom=8'hB7;
  11'h202:boot_rom=8'h28;
  11'h203:boot_rom=8'h09;
  11'h204:boot_rom=8'h47;
  11'h205:boot_rom=8'hCD;
  11'h206:boot_rom=8'h68;
  11'h207:boot_rom=8'h11;
  11'h208:boot_rom=8'h12;
  11'h209:boot_rom=8'h23;
  11'h20A:boot_rom=8'h13;
  11'h20B:boot_rom=8'h10;
  11'h20C:boot_rom=8'hF8;
  11'h20D:boot_rom=8'hC3;
  11'h20E:boot_rom=8'h08;
  11'h20F:boot_rom=8'h03;
  11'h210:boot_rom=8'h3A;
  11'h211:boot_rom=8'h6E;
  11'h212:boot_rom=8'h40;
  11'h213:boot_rom=8'h32;
  11'h214:boot_rom=8'h00;
  11'h215:boot_rom=8'hC0;
  11'h216:boot_rom=8'h21;
  11'h217:boot_rom=8'h71;
  11'h218:boot_rom=8'h40;
  11'h219:boot_rom=8'hED;
  11'h21A:boot_rom=8'h5B;
  11'h21B:boot_rom=8'h6F;
  11'h21C:boot_rom=8'h40;
  11'h21D:boot_rom=8'h3A;
  11'h21E:boot_rom=8'h6D;
  11'h21F:boot_rom=8'h40;
  11'h220:boot_rom=8'hD6;
  11'h221:boot_rom=8'h03;
  11'h222:boot_rom=8'h28;
  11'h223:boot_rom=8'h1C;
  11'h224:boot_rom=8'h47;
  11'h225:boot_rom=8'hC5;
  11'h226:boot_rom=8'h7E;
  11'h227:boot_rom=8'hCD;
  11'h228:boot_rom=8'h65;
  11'h229:boot_rom=8'h11;
  11'h22A:boot_rom=8'h23;
  11'h22B:boot_rom=8'h13;
  11'h22C:boot_rom=8'h10;
  11'h22D:boot_rom=8'hF8;
  11'h22E:boot_rom=8'h21;
  11'h22F:boot_rom=8'h71;
  11'h230:boot_rom=8'h40;
  11'h231:boot_rom=8'hED;
  11'h232:boot_rom=8'h5B;
  11'h233:boot_rom=8'h6F;
  11'h234:boot_rom=8'h40;
  11'h235:boot_rom=8'hC1;
  11'h236:boot_rom=8'hCD;
  11'h237:boot_rom=8'h62;
  11'h238:boot_rom=8'h11;
  11'h239:boot_rom=8'hBE;
  11'h23A:boot_rom=8'h20;
  11'h23B:boot_rom=8'h07;
  11'h23C:boot_rom=8'h23;
  11'h23D:boot_rom=8'h13;
  11'h23E:boot_rom=8'h10;
  11'h23F:boot_rom=8'hF6;
  11'h240:boot_rom=8'hAF;
  11'h241:boot_rom=8'h18;
  11'h242:boot_rom=8'h02;
  11'h243:boot_rom=8'h3E;
  11'h244:boot_rom=8'h01;
  11'h245:boot_rom=8'hC3;
  11'h246:boot_rom=8'hFE;
  11'h247:boot_rom=8'h02;
  11'h248:boot_rom=8'h21;
  11'h249:boot_rom=8'h50;
  11'h24A:boot_rom=8'h40;
  11'h24B:boot_rom=8'h3E;
  11'h24C:boot_rom=8'h1C;
  11'h24D:boot_rom=8'h11;
  11'h24E:boot_rom=8'h6D;
  11'h24F:boot_rom=8'h40;
  11'h250:boot_rom=8'h12;
  11'h251:boot_rom=8'h13;
  11'h252:boot_rom=8'h47;
  11'h253:boot_rom=8'h7E;
  11'h254:boot_rom=8'h12;
  11'h255:boot_rom=8'h23;
  11'h256:boot_rom=8'h13;
  11'h257:boot_rom=8'h10;
  11'h258:boot_rom=8'hFA;
  11'h259:boot_rom=8'hC3;
  11'h25A:boot_rom=8'h08;
  11'h25B:boot_rom=8'h03;
  11'h25C:boot_rom=8'h21;
  11'h25D:boot_rom=8'h6E;
  11'h25E:boot_rom=8'h40;
  11'h25F:boot_rom=8'h3A;
  11'h260:boot_rom=8'h6D;
  11'h261:boot_rom=8'h40;
  11'h262:boot_rom=8'hB7;
  11'h263:boot_rom=8'h28;
  11'h264:boot_rom=8'h0A;
  11'h265:boot_rom=8'h11;
  11'h266:boot_rom=8'h50;
  11'h267:boot_rom=8'h40;
  11'h268:boot_rom=8'h47;
  11'h269:boot_rom=8'h7E;
  11'h26A:boot_rom=8'h12;
  11'h26B:boot_rom=8'h23;
  11'h26C:boot_rom=8'h13;
  11'h26D:boot_rom=8'h10;
  11'h26E:boot_rom=8'hFA;
  11'h26F:boot_rom=8'hAF;
  11'h270:boot_rom=8'hC3;
  11'h271:boot_rom=8'hFE;
  11'h272:boot_rom=8'h02;
  11'h273:boot_rom=8'hAF;
  11'h274:boot_rom=8'h32;
  11'h275:boot_rom=8'h00;
  11'h276:boot_rom=8'hC0;
  11'h277:boot_rom=8'hED;
  11'h278:boot_rom=8'h5B;
  11'h279:boot_rom=8'h52;
  11'h27A:boot_rom=8'h40;
  11'h27B:boot_rom=8'h1B;
  11'h27C:boot_rom=8'h3A;
  11'h27D:boot_rom=8'h61;
  11'h27E:boot_rom=8'h40;
  11'h27F:boot_rom=8'hCD;
  11'h280:boot_rom=8'h65;
  11'h281:boot_rom=8'h11;
  11'h282:boot_rom=8'h1B;
  11'h283:boot_rom=8'h3A;
  11'h284:boot_rom=8'h60;
  11'h285:boot_rom=8'h40;
  11'h286:boot_rom=8'hCD;
  11'h287:boot_rom=8'h65;
  11'h288:boot_rom=8'h11;
  11'h289:boot_rom=8'hED;
  11'h28A:boot_rom=8'h53;
  11'h28B:boot_rom=8'h52;
  11'h28C:boot_rom=8'h40;
  11'h28D:boot_rom=8'h31;
  11'h28E:boot_rom=8'h54;
  11'h28F:boot_rom=8'h40;
  11'h290:boot_rom=8'hDD;
  11'h291:boot_rom=8'hE1;
  11'h292:boot_rom=8'hFD;
  11'h293:boot_rom=8'hE1;
  11'h294:boot_rom=8'hE1;
  11'h295:boot_rom=8'hC1;
  11'h296:boot_rom=8'hD1;
  11'h297:boot_rom=8'hF1;
  11'h298:boot_rom=8'hD9;
  11'h299:boot_rom=8'h08;
  11'h29A:boot_rom=8'hF1;
  11'h29B:boot_rom=8'hE1;
  11'h29C:boot_rom=8'h7D;
  11'h29D:boot_rom=8'hED;
  11'h29E:boot_rom=8'h47;
  11'h29F:boot_rom=8'h7C;
  11'h2A0:boot_rom=8'hB7;
  11'h2A1:boot_rom=8'h28;
  11'h2A2:boot_rom=8'h01;
  11'h2A3:boot_rom=8'hFB;
  11'h2A4:boot_rom=8'hE1;
  11'h2A5:boot_rom=8'hC1;
  11'h2A6:boot_rom=8'hD1;
  11'h2A7:boot_rom=8'hF1;
  11'h2A8:boot_rom=8'hD9;
  11'h2A9:boot_rom=8'h08;
  11'h2AA:boot_rom=8'hED;
  11'h2AB:boot_rom=8'h7B;
  11'h2AC:boot_rom=8'h52;
  11'h2AD:boot_rom=8'h40;
  11'h2AE:boot_rom=8'hC3;
  11'h2AF:boot_rom=8'h24;
  11'h2B0:boot_rom=8'h30;
  11'h2B1:boot_rom=8'h21;
  11'h2B2:boot_rom=8'h6D;
  11'h2B3:boot_rom=8'h40;
  11'h2B4:boot_rom=8'h46;
  11'h2B5:boot_rom=8'h23;
  11'h2B6:boot_rom=8'h04;
  11'h2B7:boot_rom=8'h05;
  11'h2B8:boot_rom=8'h0E;
  11'h2B9:boot_rom=8'h00;
  11'h2BA:boot_rom=8'h28;
  11'h2BB:boot_rom=8'h25;
  11'h2BC:boot_rom=8'hE5;
  11'h2BD:boot_rom=8'hDD;
  11'h2BE:boot_rom=8'hE1;
  11'h2BF:boot_rom=8'h7E;
  11'h2C0:boot_rom=8'h23;
  11'h2C1:boot_rom=8'h32;
  11'h2C2:boot_rom=8'h00;
  11'h2C3:boot_rom=8'hC0;
  11'h2C4:boot_rom=8'h5E;
  11'h2C5:boot_rom=8'h23;
  11'h2C6:boot_rom=8'h56;
  11'h2C7:boot_rom=8'h23;
  11'h2C8:boot_rom=8'hCD;
  11'h2C9:boot_rom=8'h62;
  11'h2CA:boot_rom=8'h11;
  11'h2CB:boot_rom=8'hDD;
  11'h2CC:boot_rom=8'h77;
  11'h2CD:boot_rom=8'h00;
  11'h2CE:boot_rom=8'hDD;
  11'h2CF:boot_rom=8'h23;
  11'h2D0:boot_rom=8'h7E;
  11'h2D1:boot_rom=8'hCD;
  11'h2D2:boot_rom=8'h65;
  11'h2D3:boot_rom=8'h11;
  11'h2D4:boot_rom=8'hCD;
  11'h2D5:boot_rom=8'h62;
  11'h2D6:boot_rom=8'h11;
  11'h2D7:boot_rom=8'hBE;
  11'h2D8:boot_rom=8'h20;
  11'h2D9:boot_rom=8'h07;
  11'h2DA:boot_rom=8'h23;
  11'h2DB:boot_rom=8'h0C;
  11'h2DC:boot_rom=8'h05;
  11'h2DD:boot_rom=8'h05;
  11'h2DE:boot_rom=8'h05;
  11'h2DF:boot_rom=8'h10;
  11'h2E0:boot_rom=8'hDE;
  11'h2E1:boot_rom=8'h79;
  11'h2E2:boot_rom=8'h32;
  11'h2E3:boot_rom=8'h6D;
  11'h2E4:boot_rom=8'h40;
  11'h2E5:boot_rom=8'hC3;
  11'h2E6:boot_rom=8'h08;
  11'h2E7:boot_rom=8'h03;
  11'h2E8:boot_rom=8'hED;
  11'h2E9:boot_rom=8'h4B;
  11'h2EA:boot_rom=8'h6E;
  11'h2EB:boot_rom=8'h40;
  11'h2EC:boot_rom=8'hED;
  11'h2ED:boot_rom=8'h78;
  11'h2EE:boot_rom=8'hC3;
  11'h2EF:boot_rom=8'hFE;
  11'h2F0:boot_rom=8'h02;
  11'h2F1:boot_rom=8'hED;
  11'h2F2:boot_rom=8'h4B;
  11'h2F3:boot_rom=8'h6E;
  11'h2F4:boot_rom=8'h40;
  11'h2F5:boot_rom=8'h3A;
  11'h2F6:boot_rom=8'h70;
  11'h2F7:boot_rom=8'h40;
  11'h2F8:boot_rom=8'hED;
  11'h2F9:boot_rom=8'h79;
  11'h2FA:boot_rom=8'hAF;
  11'h2FB:boot_rom=8'hC3;
  11'h2FC:boot_rom=8'hFE;
  11'h2FD:boot_rom=8'h02;
  11'h2FE:boot_rom=8'h32;
  11'h2FF:boot_rom=8'h6E;
  11'h300:boot_rom=8'h40;
  11'h301:boot_rom=8'h3E;
  11'h302:boot_rom=8'h01;
  11'h303:boot_rom=8'h32;
  11'h304:boot_rom=8'h6D;
  11'h305:boot_rom=8'h40;
  11'h306:boot_rom=8'h18;
  11'h307:boot_rom=8'h00;
  11'h308:boot_rom=8'hCD;
  11'h309:boot_rom=8'h21;
  11'h30A:boot_rom=8'h03;
  11'h30B:boot_rom=8'hED;
  11'h30C:boot_rom=8'h44;
  11'h30D:boot_rom=8'h77;
  11'h30E:boot_rom=8'h21;
  11'h30F:boot_rom=8'h6C;
  11'h310:boot_rom=8'h40;
  11'h311:boot_rom=8'h3A;
  11'h312:boot_rom=8'h6D;
  11'h313:boot_rom=8'h40;
  11'h314:boot_rom=8'hC6;
  11'h315:boot_rom=8'h03;
  11'h316:boot_rom=8'h47;
  11'h317:boot_rom=8'h7E;
  11'h318:boot_rom=8'hCD;
  11'h319:boot_rom=8'h28;
  11'h31A:boot_rom=8'h00;
  11'h31B:boot_rom=8'h23;
  11'h31C:boot_rom=8'h10;
  11'h31D:boot_rom=8'hF9;
  11'h31E:boot_rom=8'hC3;
  11'h31F:boot_rom=8'h71;
  11'h320:boot_rom=8'h01;
  11'h321:boot_rom=8'h21;
  11'h322:boot_rom=8'h6C;
  11'h323:boot_rom=8'h40;
  11'h324:boot_rom=8'h3A;
  11'h325:boot_rom=8'h6D;
  11'h326:boot_rom=8'h40;
  11'h327:boot_rom=8'hC6;
  11'h328:boot_rom=8'h02;
  11'h329:boot_rom=8'h47;
  11'h32A:boot_rom=8'hAF;
  11'h32B:boot_rom=8'h86;
  11'h32C:boot_rom=8'h23;
  11'h32D:boot_rom=8'h10;
  11'h32E:boot_rom=8'hFC;
  11'h32F:boot_rom=8'hC9;
  11'h330:boot_rom=8'h21;
  11'h331:boot_rom=8'h23;
  11'h332:boot_rom=8'h06;
  11'h333:boot_rom=8'hCF;
  11'h334:boot_rom=8'h21;
  11'h335:boot_rom=8'h00;
  11'h336:boot_rom=8'h00;
  11'h337:boot_rom=8'h11;
  11'h338:boot_rom=8'h00;
  11'h339:boot_rom=8'h05;
  11'h33A:boot_rom=8'hC5;
  11'h33B:boot_rom=8'hAF;
  11'h33C:boot_rom=8'hCD;
  11'h33D:boot_rom=8'h68;
  11'h33E:boot_rom=8'h05;
  11'h33F:boot_rom=8'hC1;
  11'h340:boot_rom=8'hD5;
  11'h341:boot_rom=8'hE5;
  11'h342:boot_rom=8'h16;
  11'h343:boot_rom=8'h00;
  11'h344:boot_rom=8'h3E;
  11'h345:boot_rom=8'h0F;
  11'h346:boot_rom=8'h32;
  11'h347:boot_rom=8'hFF;
  11'h348:boot_rom=8'h40;
  11'h349:boot_rom=8'h7A;
  11'h34A:boot_rom=8'hCD;
  11'h34B:boot_rom=8'h79;
  11'h34C:boot_rom=8'h05;
  11'h34D:boot_rom=8'h0B;
  11'h34E:boot_rom=8'hCD;
  11'h34F:boot_rom=8'h91;
  11'h350:boot_rom=8'h03;
  11'h351:boot_rom=8'hCB;
  11'h352:boot_rom=8'h47;
  11'h353:boot_rom=8'h28;
  11'h354:boot_rom=8'h0F;
  11'h355:boot_rom=8'hCB;
  11'h356:boot_rom=8'h4F;
  11'h357:boot_rom=8'h28;
  11'h358:boot_rom=8'h06;
  11'h359:boot_rom=8'hCB;
  11'h35A:boot_rom=8'h6F;
  11'h35B:boot_rom=8'h28;
  11'h35C:boot_rom=8'h0E;
  11'h35D:boot_rom=8'h18;
  11'h35E:boot_rom=8'hE5;
  11'h35F:boot_rom=8'h14;
  11'h360:boot_rom=8'hCB;
  11'h361:boot_rom=8'hA2;
  11'h362:boot_rom=8'h18;
  11'h363:boot_rom=8'hE0;
  11'h364:boot_rom=8'h15;
  11'h365:boot_rom=8'h7A;
  11'h366:boot_rom=8'hE6;
  11'h367:boot_rom=8'h0F;
  11'h368:boot_rom=8'h57;
  11'h369:boot_rom=8'h18;
  11'h36A:boot_rom=8'hD9;
  11'h36B:boot_rom=8'h3E;
  11'h36C:boot_rom=8'h07;
  11'h36D:boot_rom=8'h32;
  11'h36E:boot_rom=8'hFF;
  11'h36F:boot_rom=8'h40;
  11'h370:boot_rom=8'h7A;
  11'h371:boot_rom=8'hCD;
  11'h372:boot_rom=8'h79;
  11'h373:boot_rom=8'h05;
  11'h374:boot_rom=8'h7A;
  11'h375:boot_rom=8'hE1;
  11'h376:boot_rom=8'hD1;
  11'h377:boot_rom=8'h29;
  11'h378:boot_rom=8'hCB;
  11'h379:boot_rom=8'h13;
  11'h37A:boot_rom=8'h29;
  11'h37B:boot_rom=8'hCB;
  11'h37C:boot_rom=8'h13;
  11'h37D:boot_rom=8'h29;
  11'h37E:boot_rom=8'hCB;
  11'h37F:boot_rom=8'h13;
  11'h380:boot_rom=8'h29;
  11'h381:boot_rom=8'hCB;
  11'h382:boot_rom=8'h13;
  11'h383:boot_rom=8'hB5;
  11'h384:boot_rom=8'h6F;
  11'h385:boot_rom=8'h15;
  11'h386:boot_rom=8'h20;
  11'h387:boot_rom=8'hB8;
  11'h388:boot_rom=8'h7B;
  11'h389:boot_rom=8'hC9;
  11'h38A:boot_rom=8'hCD;
  11'h38B:boot_rom=8'h9C;
  11'h38C:boot_rom=8'h03;
  11'h38D:boot_rom=8'h3C;
  11'h38E:boot_rom=8'h20;
  11'h38F:boot_rom=8'hFA;
  11'h390:boot_rom=8'hC9;
  11'h391:boot_rom=8'hCD;
  11'h392:boot_rom=8'h8A;
  11'h393:boot_rom=8'h03;
  11'h394:boot_rom=8'hCD;
  11'h395:boot_rom=8'h9C;
  11'h396:boot_rom=8'h03;
  11'h397:boot_rom=8'h3C;
  11'h398:boot_rom=8'h28;
  11'h399:boot_rom=8'hFA;
  11'h39A:boot_rom=8'h3D;
  11'h39B:boot_rom=8'hC9;
  11'h39C:boot_rom=8'hC5;
  11'h39D:boot_rom=8'h3E;
  11'h39E:boot_rom=8'h0E;
  11'h39F:boot_rom=8'h06;
  11'h3A0:boot_rom=8'h1C;
  11'h3A1:boot_rom=8'hED;
  11'h3A2:boot_rom=8'h79;
  11'h3A3:boot_rom=8'h05;
  11'h3A4:boot_rom=8'hED;
  11'h3A5:boot_rom=8'h78;
  11'h3A6:boot_rom=8'hC1;
  11'h3A7:boot_rom=8'hC9;
  11'h3A8:boot_rom=8'hED;
  11'h3A9:boot_rom=8'h79;
  11'h3AA:boot_rom=8'hCB;
  11'h3AB:boot_rom=8'hA0;
  11'h3AC:boot_rom=8'h3A;
  11'h3AD:boot_rom=8'hFF;
  11'h3AE:boot_rom=8'h40;
  11'h3AF:boot_rom=8'hED;
  11'h3B0:boot_rom=8'h79;
  11'h3B1:boot_rom=8'hCB;
  11'h3B2:boot_rom=8'hE0;
  11'h3B3:boot_rom=8'h03;
  11'h3B4:boot_rom=8'hC9;
  11'h3B5:boot_rom=8'h4E;
  11'h3B6:boot_rom=8'h23;
  11'h3B7:boot_rom=8'h46;
  11'h3B8:boot_rom=8'h23;
  11'h3B9:boot_rom=8'h7E;
  11'h3BA:boot_rom=8'h23;
  11'h3BB:boot_rom=8'hB7;
  11'h3BC:boot_rom=8'hC8;
  11'h3BD:boot_rom=8'hCD;
  11'h3BE:boot_rom=8'hA8;
  11'h3BF:boot_rom=8'h03;
  11'h3C0:boot_rom=8'h18;
  11'h3C1:boot_rom=8'hF7;
  11'h3C2:boot_rom=8'h06;
  11'h3C3:boot_rom=8'h19;
  11'h3C4:boot_rom=8'h3E;
  11'h3C5:boot_rom=8'hF0;
  11'h3C6:boot_rom=8'hED;
  11'h3C7:boot_rom=8'h79;
  11'h3C8:boot_rom=8'hED;
  11'h3C9:boot_rom=8'h49;
  11'h3CA:boot_rom=8'hAF;
  11'h3CB:boot_rom=8'hED;
  11'h3CC:boot_rom=8'h79;
  11'h3CD:boot_rom=8'h21;
  11'h3CE:boot_rom=8'hBF;
  11'h3CF:boot_rom=8'h05;
  11'h3D0:boot_rom=8'h06;
  11'h3D1:boot_rom=8'h00;
  11'h3D2:boot_rom=8'hC5;
  11'h3D3:boot_rom=8'h78;
  11'h3D4:boot_rom=8'hB9;
  11'h3D5:boot_rom=8'h3E;
  11'h3D6:boot_rom=8'h07;
  11'h3D7:boot_rom=8'h20;
  11'h3D8:boot_rom=8'h02;
  11'h3D9:boot_rom=8'h3E;
  11'h3DA:boot_rom=8'h0F;
  11'h3DB:boot_rom=8'h32;
  11'h3DC:boot_rom=8'hFF;
  11'h3DD:boot_rom=8'h40;
  11'h3DE:boot_rom=8'hCF;
  11'h3DF:boot_rom=8'hC1;
  11'h3E0:boot_rom=8'h04;
  11'h3E1:boot_rom=8'h78;
  11'h3E2:boot_rom=8'hFE;
  11'h3E3:boot_rom=8'h06;
  11'h3E4:boot_rom=8'h38;
  11'h3E5:boot_rom=8'hEC;
  11'h3E6:boot_rom=8'h3E;
  11'h3E7:boot_rom=8'h07;
  11'h3E8:boot_rom=8'h32;
  11'h3E9:boot_rom=8'hFF;
  11'h3EA:boot_rom=8'h40;
  11'h3EB:boot_rom=8'hC9;
  11'h3EC:boot_rom=8'h0D;
  11'h3ED:boot_rom=8'h79;
  11'h3EE:boot_rom=8'hE6;
  11'h3EF:boot_rom=8'h80;
  11'h3F0:boot_rom=8'h28;
  11'h3F1:boot_rom=8'h3D;
  11'h3F2:boot_rom=8'h0E;
  11'h3F3:boot_rom=8'h05;
  11'h3F4:boot_rom=8'h18;
  11'h3F5:boot_rom=8'h39;
  11'h3F6:boot_rom=8'h0C;
  11'h3F7:boot_rom=8'h79;
  11'h3F8:boot_rom=8'hFE;
  11'h3F9:boot_rom=8'h06;
  11'h3FA:boot_rom=8'h38;
  11'h3FB:boot_rom=8'h33;
  11'h3FC:boot_rom=8'h0E;
  11'h3FD:boot_rom=8'h00;
  11'h3FE:boot_rom=8'h18;
  11'h3FF:boot_rom=8'h2F;
  11'h400:boot_rom=8'h21;
  11'h401:boot_rom=8'h5C;
  11'h402:boot_rom=8'h04;
  11'h403:boot_rom=8'hE5;
  11'h404:boot_rom=8'h06;
  11'h405:boot_rom=8'h19;
  11'h406:boot_rom=8'h3E;
  11'h407:boot_rom=8'hF0;
  11'h408:boot_rom=8'hED;
  11'h409:boot_rom=8'h79;
  11'h40A:boot_rom=8'hED;
  11'h40B:boot_rom=8'h49;
  11'h40C:boot_rom=8'h3E;
  11'h40D:boot_rom=8'h01;
  11'h40E:boot_rom=8'hED;
  11'h40F:boot_rom=8'h79;
  11'h410:boot_rom=8'h79;
  11'h411:boot_rom=8'h87;
  11'h412:boot_rom=8'hC6;
  11'h413:boot_rom=8'h87;
  11'h414:boot_rom=8'h6F;
  11'h415:boot_rom=8'h26;
  11'h416:boot_rom=8'h05;
  11'h417:boot_rom=8'h7E;
  11'h418:boot_rom=8'h23;
  11'h419:boot_rom=8'h66;
  11'h41A:boot_rom=8'h6F;
  11'h41B:boot_rom=8'hE9;
  11'h41C:boot_rom=8'hCD;
  11'h41D:boot_rom=8'hD9;
  11'h41E:boot_rom=8'h04;
  11'h41F:boot_rom=8'h30;
  11'h420:boot_rom=8'h5C;
  11'h421:boot_rom=8'h3E;
  11'h422:boot_rom=8'h07;
  11'h423:boot_rom=8'h32;
  11'h424:boot_rom=8'hFF;
  11'h425:boot_rom=8'h40;
  11'h426:boot_rom=8'hCD;
  11'h427:boot_rom=8'h19;
  11'h428:boot_rom=8'h07;
  11'h429:boot_rom=8'h21;
  11'h42A:boot_rom=8'h93;
  11'h42B:boot_rom=8'h05;
  11'h42C:boot_rom=8'hCF;
  11'h42D:boot_rom=8'h0E;
  11'h42E:boot_rom=8'h00;
  11'h42F:boot_rom=8'hCD;
  11'h430:boot_rom=8'h8A;
  11'h431:boot_rom=8'h03;
  11'h432:boot_rom=8'hCD;
  11'h433:boot_rom=8'hC2;
  11'h434:boot_rom=8'h03;
  11'h435:boot_rom=8'hCD;
  11'h436:boot_rom=8'h9C;
  11'h437:boot_rom=8'h03;
  11'h438:boot_rom=8'hCB;
  11'h439:boot_rom=8'h47;
  11'h43A:boot_rom=8'h28;
  11'h43B:boot_rom=8'hB0;
  11'h43C:boot_rom=8'hCB;
  11'h43D:boot_rom=8'h4F;
  11'h43E:boot_rom=8'h28;
  11'h43F:boot_rom=8'hB6;
  11'h440:boot_rom=8'hCB;
  11'h441:boot_rom=8'h6F;
  11'h442:boot_rom=8'h28;
  11'h443:boot_rom=8'hBC;
  11'h444:boot_rom=8'h3A;
  11'h445:boot_rom=8'h00;
  11'h446:boot_rom=8'hC0;
  11'h447:boot_rom=8'hCB;
  11'h448:boot_rom=8'h47;
  11'h449:boot_rom=8'h28;
  11'h44A:boot_rom=8'hEA;
  11'h44B:boot_rom=8'hCD;
  11'h44C:boot_rom=8'h14;
  11'h44D:boot_rom=8'h00;
  11'h44E:boot_rom=8'hD6;
  11'h44F:boot_rom=8'h30;
  11'h450:boot_rom=8'h38;
  11'h451:boot_rom=8'hE3;
  11'h452:boot_rom=8'hFE;
  11'h453:boot_rom=8'h06;
  11'h454:boot_rom=8'h30;
  11'h455:boot_rom=8'hDF;
  11'h456:boot_rom=8'h4F;
  11'h457:boot_rom=8'hCD;
  11'h458:boot_rom=8'hC2;
  11'h459:boot_rom=8'h03;
  11'h45A:boot_rom=8'h18;
  11'h45B:boot_rom=8'hA4;
  11'h45C:boot_rom=8'h21;
  11'h45D:boot_rom=8'hB0;
  11'h45E:boot_rom=8'h05;
  11'h45F:boot_rom=8'hCF;
  11'h460:boot_rom=8'hCD;
  11'h461:boot_rom=8'h91;
  11'h462:boot_rom=8'h03;
  11'h463:boot_rom=8'h18;
  11'h464:boot_rom=8'hBC;
  11'h465:boot_rom=8'h3E;
  11'h466:boot_rom=8'h01;
  11'h467:boot_rom=8'h18;
  11'h468:boot_rom=8'h09;
  11'h469:boot_rom=8'h3E;
  11'h46A:boot_rom=8'h07;
  11'h46B:boot_rom=8'h21;
  11'h46C:boot_rom=8'h00;
  11'h46D:boot_rom=8'h80;
  11'h46E:boot_rom=8'h18;
  11'h46F:boot_rom=8'h0A;
  11'h470:boot_rom=8'h3E;
  11'h471:boot_rom=8'h0E;
  11'h472:boot_rom=8'h21;
  11'h473:boot_rom=8'h00;
  11'h474:boot_rom=8'h00;
  11'h475:boot_rom=8'h18;
  11'h476:boot_rom=8'h03;
  11'h477:boot_rom=8'hCD;
  11'h478:boot_rom=8'h30;
  11'h479:boot_rom=8'h03;
  11'h47A:boot_rom=8'hC3;
  11'h47B:boot_rom=8'h98;
  11'h47C:boot_rom=8'h04;
  11'h47D:boot_rom=8'h3E;
  11'h47E:boot_rom=8'h0E;
  11'h47F:boot_rom=8'h21;
  11'h480:boot_rom=8'h00;
  11'h481:boot_rom=8'h00;
  11'h482:boot_rom=8'h18;
  11'h483:boot_rom=8'h03;
  11'h484:boot_rom=8'hCD;
  11'h485:boot_rom=8'h30;
  11'h486:boot_rom=8'h03;
  11'h487:boot_rom=8'hB7;
  11'h488:boot_rom=8'h3E;
  11'h489:boot_rom=8'h1D;
  11'h48A:boot_rom=8'h20;
  11'h48B:boot_rom=8'h01;
  11'h48C:boot_rom=8'h3C;
  11'h48D:boot_rom=8'hD3;
  11'h48E:boot_rom=8'h00;
  11'h48F:boot_rom=8'h22;
  11'h490:boot_rom=8'h60;
  11'h491:boot_rom=8'h40;
  11'h492:boot_rom=8'h22;
  11'h493:boot_rom=8'h52;
  11'h494:boot_rom=8'h40;
  11'h495:boot_rom=8'hC3;
  11'h496:boot_rom=8'h73;
  11'h497:boot_rom=8'h02;
  11'h498:boot_rom=8'hF5;
  11'h499:boot_rom=8'hE5;
  11'h49A:boot_rom=8'h21;
  11'h49B:boot_rom=8'h2C;
  11'h49C:boot_rom=8'h06;
  11'h49D:boot_rom=8'hCF;
  11'h49E:boot_rom=8'hE1;
  11'h49F:boot_rom=8'hF1;
  11'h4A0:boot_rom=8'hF5;
  11'h4A1:boot_rom=8'hE5;
  11'h4A2:boot_rom=8'hCD;
  11'h4A3:boot_rom=8'h68;
  11'h4A4:boot_rom=8'h05;
  11'h4A5:boot_rom=8'hE1;
  11'h4A6:boot_rom=8'hF1;
  11'h4A7:boot_rom=8'h4F;
  11'h4A8:boot_rom=8'h32;
  11'h4A9:boot_rom=8'h00;
  11'h4AA:boot_rom=8'hC0;
  11'h4AB:boot_rom=8'hCD;
  11'h4AC:boot_rom=8'h14;
  11'h4AD:boot_rom=8'h00;
  11'h4AE:boot_rom=8'h38;
  11'h4AF:boot_rom=8'hFB;
  11'h4B0:boot_rom=8'hEB;
  11'h4B1:boot_rom=8'hCD;
  11'h4B2:boot_rom=8'h65;
  11'h4B3:boot_rom=8'h11;
  11'h4B4:boot_rom=8'hEB;
  11'h4B5:boot_rom=8'hC5;
  11'h4B6:boot_rom=8'h01;
  11'h4B7:boot_rom=8'hE0;
  11'h4B8:boot_rom=8'h31;
  11'h4B9:boot_rom=8'hED;
  11'h4BA:boot_rom=8'h79;
  11'h4BB:boot_rom=8'hC1;
  11'h4BC:boot_rom=8'h2C;
  11'h4BD:boot_rom=8'h20;
  11'h4BE:boot_rom=8'h08;
  11'h4BF:boot_rom=8'h24;
  11'h4C0:boot_rom=8'h20;
  11'h4C1:boot_rom=8'h05;
  11'h4C2:boot_rom=8'h0C;
  11'h4C3:boot_rom=8'h79;
  11'h4C4:boot_rom=8'h32;
  11'h4C5:boot_rom=8'h00;
  11'h4C6:boot_rom=8'hC0;
  11'h4C7:boot_rom=8'hCD;
  11'h4C8:boot_rom=8'h14;
  11'h4C9:boot_rom=8'h00;
  11'h4CA:boot_rom=8'h30;
  11'h4CB:boot_rom=8'hE4;
  11'h4CC:boot_rom=8'h79;
  11'h4CD:boot_rom=8'hF5;
  11'h4CE:boot_rom=8'hE5;
  11'h4CF:boot_rom=8'h21;
  11'h4D0:boot_rom=8'h35;
  11'h4D1:boot_rom=8'h06;
  11'h4D2:boot_rom=8'hCF;
  11'h4D3:boot_rom=8'hE1;
  11'h4D4:boot_rom=8'hF1;
  11'h4D5:boot_rom=8'hCD;
  11'h4D6:boot_rom=8'h68;
  11'h4D7:boot_rom=8'h05;
  11'h4D8:boot_rom=8'hC9;
  11'h4D9:boot_rom=8'h01;
  11'h4DA:boot_rom=8'h40;
  11'h4DB:boot_rom=8'h0E;
  11'h4DC:boot_rom=8'hED;
  11'h4DD:boot_rom=8'h79;
  11'h4DE:boot_rom=8'hCD;
  11'h4DF:boot_rom=8'h60;
  11'h4E0:boot_rom=8'h05;
  11'h4E1:boot_rom=8'h1E;
  11'h4E2:boot_rom=8'h31;
  11'h4E3:boot_rom=8'h1D;
  11'h4E4:boot_rom=8'h28;
  11'h4E5:boot_rom=8'h6F;
  11'h4E6:boot_rom=8'h01;
  11'h4E7:boot_rom=8'h51;
  11'h4E8:boot_rom=8'h0E;
  11'h4E9:boot_rom=8'hED;
  11'h4EA:boot_rom=8'h79;
  11'h4EB:boot_rom=8'hED;
  11'h4EC:boot_rom=8'h78;
  11'h4ED:boot_rom=8'hFE;
  11'h4EE:boot_rom=8'h55;
  11'h4EF:boot_rom=8'h20;
  11'h4F0:boot_rom=8'hF2;
  11'h4F1:boot_rom=8'hCD;
  11'h4F2:boot_rom=8'h57;
  11'h4F3:boot_rom=8'h05;
  11'h4F4:boot_rom=8'hFE;
  11'h4F5:boot_rom=8'h99;
  11'h4F6:boot_rom=8'h20;
  11'h4F7:boot_rom=8'h5D;
  11'h4F8:boot_rom=8'hCD;
  11'h4F9:boot_rom=8'h57;
  11'h4FA:boot_rom=8'h05;
  11'h4FB:boot_rom=8'hFE;
  11'h4FC:boot_rom=8'hAA;
  11'h4FD:boot_rom=8'h20;
  11'h4FE:boot_rom=8'h56;
  11'h4FF:boot_rom=8'hCD;
  11'h500:boot_rom=8'h57;
  11'h501:boot_rom=8'h05;
  11'h502:boot_rom=8'hFE;
  11'h503:boot_rom=8'h66;
  11'h504:boot_rom=8'h20;
  11'h505:boot_rom=8'h4F;
  11'h506:boot_rom=8'h21;
  11'h507:boot_rom=8'h93;
  11'h508:boot_rom=8'h05;
  11'h509:boot_rom=8'hCF;
  11'h50A:boot_rom=8'h21;
  11'h50B:boot_rom=8'h3E;
  11'h50C:boot_rom=8'h06;
  11'h50D:boot_rom=8'hCF;
  11'h50E:boot_rom=8'h1E;
  11'h50F:boot_rom=8'hFF;
  11'h510:boot_rom=8'h21;
  11'h511:boot_rom=8'h04;
  11'h512:boot_rom=8'h00;
  11'h513:boot_rom=8'hCD;
  11'h514:boot_rom=8'h60;
  11'h515:boot_rom=8'h05;
  11'h516:boot_rom=8'h2C;
  11'h517:boot_rom=8'h20;
  11'h518:boot_rom=8'hFA;
  11'h519:boot_rom=8'hCD;
  11'h51A:boot_rom=8'h9C;
  11'h51B:boot_rom=8'h03;
  11'h51C:boot_rom=8'h3C;
  11'h51D:boot_rom=8'h37;
  11'h51E:boot_rom=8'hC0;
  11'h51F:boot_rom=8'h24;
  11'h520:boot_rom=8'h20;
  11'h521:boot_rom=8'hF1;
  11'h522:boot_rom=8'h1C;
  11'h523:boot_rom=8'h20;
  11'h524:boot_rom=8'hEE;
  11'h525:boot_rom=8'h21;
  11'h526:boot_rom=8'h53;
  11'h527:boot_rom=8'h06;
  11'h528:boot_rom=8'hCF;
  11'h529:boot_rom=8'h2E;
  11'h52A:boot_rom=8'h01;
  11'h52B:boot_rom=8'h11;
  11'h52C:boot_rom=8'h00;
  11'h52D:boot_rom=8'h00;
  11'h52E:boot_rom=8'h26;
  11'h52F:boot_rom=8'h02;
  11'h530:boot_rom=8'h01;
  11'h531:boot_rom=8'h78;
  11'h532:boot_rom=8'h00;
  11'h533:boot_rom=8'h7D;
  11'h534:boot_rom=8'h32;
  11'h535:boot_rom=8'h00;
  11'h536:boot_rom=8'hC0;
  11'h537:boot_rom=8'hCD;
  11'h538:boot_rom=8'h57;
  11'h539:boot_rom=8'h05;
  11'h53A:boot_rom=8'hCD;
  11'h53B:boot_rom=8'h65;
  11'h53C:boot_rom=8'h11;
  11'h53D:boot_rom=8'h1C;
  11'h53E:boot_rom=8'h20;
  11'h53F:boot_rom=8'h08;
  11'h540:boot_rom=8'h14;
  11'h541:boot_rom=8'h20;
  11'h542:boot_rom=8'h05;
  11'h543:boot_rom=8'h2C;
  11'h544:boot_rom=8'h7D;
  11'h545:boot_rom=8'h32;
  11'h546:boot_rom=8'h00;
  11'h547:boot_rom=8'hC0;
  11'h548:boot_rom=8'h78;
  11'h549:boot_rom=8'hB1;
  11'h54A:boot_rom=8'h20;
  11'h54B:boot_rom=8'h04;
  11'h54C:boot_rom=8'hB4;
  11'h54D:boot_rom=8'h28;
  11'h54E:boot_rom=8'h04;
  11'h54F:boot_rom=8'h25;
  11'h550:boot_rom=8'h0B;
  11'h551:boot_rom=8'h18;
  11'h552:boot_rom=8'hE4;
  11'h553:boot_rom=8'hAF;
  11'h554:boot_rom=8'hC9;
  11'h555:boot_rom=8'h37;
  11'h556:boot_rom=8'hC9;
  11'h557:boot_rom=8'h3E;
  11'h558:boot_rom=8'h0E;
  11'h559:boot_rom=8'hD3;
  11'h55A:boot_rom=8'h58;
  11'h55B:boot_rom=8'h3E;
  11'h55C:boot_rom=8'h0E;
  11'h55D:boot_rom=8'hDB;
  11'h55E:boot_rom=8'h00;
  11'h55F:boot_rom=8'hC9;
  11'h560:boot_rom=8'h3E;
  11'h561:boot_rom=8'h0E;
  11'h562:boot_rom=8'hD3;
  11'h563:boot_rom=8'h58;
  11'h564:boot_rom=8'h00;
  11'h565:boot_rom=8'hD3;
  11'h566:boot_rom=8'h58;
  11'h567:boot_rom=8'hC9;
  11'h568:boot_rom=8'hCD;
  11'h569:boot_rom=8'h79;
  11'h56A:boot_rom=8'h05;
  11'h56B:boot_rom=8'h7C;
  11'h56C:boot_rom=8'hCD;
  11'h56D:boot_rom=8'h70;
  11'h56E:boot_rom=8'h05;
  11'h56F:boot_rom=8'h7D;
  11'h570:boot_rom=8'hF5;
  11'h571:boot_rom=8'h0F;
  11'h572:boot_rom=8'h0F;
  11'h573:boot_rom=8'h0F;
  11'h574:boot_rom=8'h0F;
  11'h575:boot_rom=8'hCD;
  11'h576:boot_rom=8'h79;
  11'h577:boot_rom=8'h05;
  11'h578:boot_rom=8'hF1;
  11'h579:boot_rom=8'hE6;
  11'h57A:boot_rom=8'h0F;
  11'h57B:boot_rom=8'hC6;
  11'h57C:boot_rom=8'h30;
  11'h57D:boot_rom=8'hFE;
  11'h57E:boot_rom=8'h3A;
  11'h57F:boot_rom=8'hDA;
  11'h580:boot_rom=8'h84;
  11'h581:boot_rom=8'h05;
  11'h582:boot_rom=8'hC6;
  11'h583:boot_rom=8'h07;
  11'h584:boot_rom=8'hC3;
  11'h585:boot_rom=8'hA8;
  11'h586:boot_rom=8'h03;
  11'h587:boot_rom=8'h65;
  11'h588:boot_rom=8'h04;
  11'h589:boot_rom=8'h69;
  11'h58A:boot_rom=8'h04;
  11'h58B:boot_rom=8'h70;
  11'h58C:boot_rom=8'h04;
  11'h58D:boot_rom=8'h77;
  11'h58E:boot_rom=8'h04;
  11'h58F:boot_rom=8'h7D;
  11'h590:boot_rom=8'h04;
  11'h591:boot_rom=8'h84;
  11'h592:boot_rom=8'h04;
  11'h593:boot_rom=8'h04;
  11'h594:boot_rom=8'h30;
  11'h595:boot_rom=8'h4E;
  11'h596:boot_rom=8'h49;
  11'h597:boot_rom=8'h53;
  11'h598:boot_rom=8'h45;
  11'h599:boot_rom=8'h2D;
  11'h59A:boot_rom=8'h58;
  11'h59B:boot_rom=8'h31;
  11'h59C:boot_rom=8'h20;
  11'h59D:boot_rom=8'h53;
  11'h59E:boot_rom=8'h6E;
  11'h59F:boot_rom=8'h61;
  11'h5A0:boot_rom=8'h70;
  11'h5A1:boot_rom=8'h53;
  11'h5A2:boot_rom=8'h68;
  11'h5A3:boot_rom=8'h6F;
  11'h5A4:boot_rom=8'h74;
  11'h5A5:boot_rom=8'h2E;
  11'h5A6:boot_rom=8'h32;
  11'h5A7:boot_rom=8'h30;
  11'h5A8:boot_rom=8'h30;
  11'h5A9:boot_rom=8'h39;
  11'h5AA:boot_rom=8'h2E;
  11'h5AB:boot_rom=8'h33;
  11'h5AC:boot_rom=8'h2E;
  11'h5AD:boot_rom=8'h31;
  11'h5AE:boot_rom=8'h36;
  11'h5AF:boot_rom=8'h00;
  11'h5B0:boot_rom=8'h20;
  11'h5B1:boot_rom=8'h33;
  11'h5B2:boot_rom=8'h50;
  11'h5B3:boot_rom=8'h55;
  11'h5B4:boot_rom=8'h53;
  11'h5B5:boot_rom=8'h48;
  11'h5B6:boot_rom=8'h20;
  11'h5B7:boot_rom=8'h54;
  11'h5B8:boot_rom=8'h52;
  11'h5B9:boot_rom=8'h49;
  11'h5BA:boot_rom=8'h47;
  11'h5BB:boot_rom=8'h47;
  11'h5BC:boot_rom=8'h45;
  11'h5BD:boot_rom=8'h52;
  11'h5BE:boot_rom=8'h00;
  11'h5BF:boot_rom=8'h58;
  11'h5C0:boot_rom=8'h30;
  11'h5C1:boot_rom=8'h4C;
  11'h5C2:boot_rom=8'h4F;
  11'h5C3:boot_rom=8'h41;
  11'h5C4:boot_rom=8'h44;
  11'h5C5:boot_rom=8'h20;
  11'h5C6:boot_rom=8'h46;
  11'h5C7:boot_rom=8'h44;
  11'h5C8:boot_rom=8'h2D;
  11'h5C9:boot_rom=8'h30;
  11'h5CA:boot_rom=8'h20;
  11'h5CB:boot_rom=8'h49;
  11'h5CC:boot_rom=8'h4D;
  11'h5CD:boot_rom=8'h47;
  11'h5CE:boot_rom=8'h28;
  11'h5CF:boot_rom=8'h2E;
  11'h5D0:boot_rom=8'h44;
  11'h5D1:boot_rom=8'h38;
  11'h5D2:boot_rom=8'h38;
  11'h5D3:boot_rom=8'h2F;
  11'h5D4:boot_rom=8'h2E;
  11'h5D5:boot_rom=8'h32;
  11'h5D6:boot_rom=8'h44;
  11'h5D7:boot_rom=8'h29;
  11'h5D8:boot_rom=8'h00;
  11'h5D9:boot_rom=8'h80;
  11'h5DA:boot_rom=8'h30;
  11'h5DB:boot_rom=8'h4C;
  11'h5DC:boot_rom=8'h4F;
  11'h5DD:boot_rom=8'h41;
  11'h5DE:boot_rom=8'h44;
  11'h5DF:boot_rom=8'h20;
  11'h5E0:boot_rom=8'h46;
  11'h5E1:boot_rom=8'h44;
  11'h5E2:boot_rom=8'h2D;
  11'h5E3:boot_rom=8'h31;
  11'h5E4:boot_rom=8'h20;
  11'h5E5:boot_rom=8'h49;
  11'h5E6:boot_rom=8'h4D;
  11'h5E7:boot_rom=8'h47;
  11'h5E8:boot_rom=8'h28;
  11'h5E9:boot_rom=8'h2E;
  11'h5EA:boot_rom=8'h44;
  11'h5EB:boot_rom=8'h38;
  11'h5EC:boot_rom=8'h38;
  11'h5ED:boot_rom=8'h2F;
  11'h5EE:boot_rom=8'h2E;
  11'h5EF:boot_rom=8'h32;
  11'h5F0:boot_rom=8'h44;
  11'h5F1:boot_rom=8'h29;
  11'h5F2:boot_rom=8'h00;
  11'h5F3:boot_rom=8'hA8;
  11'h5F4:boot_rom=8'h30;
  11'h5F5:boot_rom=8'h4C;
  11'h5F6:boot_rom=8'h4F;
  11'h5F7:boot_rom=8'h41;
  11'h5F8:boot_rom=8'h44;
  11'h5F9:boot_rom=8'h20;
  11'h5FA:boot_rom=8'h49;
  11'h5FB:boot_rom=8'h50;
  11'h5FC:boot_rom=8'h4C;
  11'h5FD:boot_rom=8'h2D;
  11'h5FE:boot_rom=8'h52;
  11'h5FF:boot_rom=8'h4F;
  11'h600:boot_rom=8'h4D;
  11'h601:boot_rom=8'h00;
  11'h602:boot_rom=8'hD0;
  11'h603:boot_rom=8'h30;
  11'h604:boot_rom=8'h4C;
  11'h605:boot_rom=8'h4F;
  11'h606:boot_rom=8'h41;
  11'h607:boot_rom=8'h44;
  11'h608:boot_rom=8'h20;
  11'h609:boot_rom=8'h41;
  11'h60A:boot_rom=8'h64;
  11'h60B:boot_rom=8'h64;
  11'h60C:boot_rom=8'h72;
  11'h60D:boot_rom=8'h65;
  11'h60E:boot_rom=8'h73;
  11'h60F:boot_rom=8'h73;
  11'h610:boot_rom=8'h00;
  11'h611:boot_rom=8'hF8;
  11'h612:boot_rom=8'h30;
  11'h613:boot_rom=8'h49;
  11'h614:boot_rom=8'h50;
  11'h615:boot_rom=8'h4C;
  11'h616:boot_rom=8'h2D;
  11'h617:boot_rom=8'h42;
  11'h618:boot_rom=8'h4F;
  11'h619:boot_rom=8'h4F;
  11'h61A:boot_rom=8'h54;
  11'h61B:boot_rom=8'h00;
  11'h61C:boot_rom=8'h48;
  11'h61D:boot_rom=8'h31;
  11'h61E:boot_rom=8'h47;
  11'h61F:boot_rom=8'h4F;
  11'h620:boot_rom=8'h54;
  11'h621:boot_rom=8'h4F;
  11'h622:boot_rom=8'h00;
  11'h623:boot_rom=8'h68;
  11'h624:boot_rom=8'h31;
  11'h625:boot_rom=8'h41;
  11'h626:boot_rom=8'h44;
  11'h627:boot_rom=8'h44;
  11'h628:boot_rom=8'h52;
  11'h629:boot_rom=8'h20;
  11'h62A:boot_rom=8'h20;
  11'h62B:boot_rom=8'h00;
  11'h62C:boot_rom=8'h90;
  11'h62D:boot_rom=8'h31;
  11'h62E:boot_rom=8'h53;
  11'h62F:boot_rom=8'h54;
  11'h630:boot_rom=8'h41;
  11'h631:boot_rom=8'h52;
  11'h632:boot_rom=8'h54;
  11'h633:boot_rom=8'h20;
  11'h634:boot_rom=8'h00;
  11'h635:boot_rom=8'hB8;
  11'h636:boot_rom=8'h31;
  11'h637:boot_rom=8'h45;
  11'h638:boot_rom=8'h4E;
  11'h639:boot_rom=8'h44;
  11'h63A:boot_rom=8'h20;
  11'h63B:boot_rom=8'h20;
  11'h63C:boot_rom=8'h20;
  11'h63D:boot_rom=8'h00;
  11'h63E:boot_rom=8'h50;
  11'h63F:boot_rom=8'h30;
  11'h640:boot_rom=8'h42;
  11'h641:boot_rom=8'h79;
  11'h642:boot_rom=8'h70;
  11'h643:boot_rom=8'h61;
  11'h644:boot_rom=8'h73;
  11'h645:boot_rom=8'h73;
  11'h646:boot_rom=8'h20;
  11'h647:boot_rom=8'h43;
  11'h648:boot_rom=8'h6F;
  11'h649:boot_rom=8'h6E;
  11'h64A:boot_rom=8'h66;
  11'h64B:boot_rom=8'h69;
  11'h64C:boot_rom=8'h67;
  11'h64D:boot_rom=8'h20;
  11'h64E:boot_rom=8'h44;
  11'h64F:boot_rom=8'h61;
  11'h650:boot_rom=8'h74;
  11'h651:boot_rom=8'h61;
  11'h652:boot_rom=8'h00;
  11'h653:boot_rom=8'h78;
  11'h654:boot_rom=8'h30;
  11'h655:boot_rom=8'h4C;
  11'h656:boot_rom=8'h6F;
  11'h657:boot_rom=8'h61;
  11'h658:boot_rom=8'h64;
  11'h659:boot_rom=8'h69;
  11'h65A:boot_rom=8'h6E;
  11'h65B:boot_rom=8'h67;
  11'h65C:boot_rom=8'h20;
  11'h65D:boot_rom=8'h46;
  11'h65E:boot_rom=8'h44;
  11'h65F:boot_rom=8'h20;
  11'h660:boot_rom=8'h49;
  11'h661:boot_rom=8'h6D;
  11'h662:boot_rom=8'h61;
  11'h663:boot_rom=8'h67;
  11'h664:boot_rom=8'h65;
  11'h665:boot_rom=8'h00;
  11'h666:boot_rom=8'hC3;
  11'h667:boot_rom=8'h07;
  11'h668:boot_rom=8'h00;
  11'h669:boot_rom=8'hC3;
  11'h66A:boot_rom=8'h06;
  11'h66B:boot_rom=8'h00;
  11'h66C:boot_rom=8'hC9;
  11'h66D:boot_rom=8'hF3;
  11'h66E:boot_rom=8'h31;
  11'h66F:boot_rom=8'h00;
  11'h670:boot_rom=8'h00;
  11'h671:boot_rom=8'h21;
  11'h672:boot_rom=8'hA4;
  11'h673:boot_rom=8'h00;
  11'h674:boot_rom=8'hCD;
  11'h675:boot_rom=8'h86;
  11'h676:boot_rom=8'h00;
  11'h677:boot_rom=8'hAF;
  11'h678:boot_rom=8'h32;
  11'h679:boot_rom=8'h87;
  11'h67A:boot_rom=8'hFF;
  11'h67B:boot_rom=8'hCD;
  11'h67C:boot_rom=8'hB3;
  11'h67D:boot_rom=8'h00;
  11'h67E:boot_rom=8'h21;
  11'h67F:boot_rom=8'hD4;
  11'h680:boot_rom=8'h00;
  11'h681:boot_rom=8'h01;
  11'h682:boot_rom=8'h00;
  11'h683:boot_rom=8'h30;
  11'h684:boot_rom=8'hCD;
  11'h685:boot_rom=8'hCB;
  11'h686:boot_rom=8'h00;
  11'h687:boot_rom=8'h3E;
  11'h688:boot_rom=8'h01;
  11'h689:boot_rom=8'h21;
  11'h68A:boot_rom=8'h00;
  11'h68B:boot_rom=8'hFE;
  11'h68C:boot_rom=8'h11;
  11'h68D:boot_rom=8'h00;
  11'h68E:boot_rom=8'h00;
  11'h68F:boot_rom=8'hCD;
  11'h690:boot_rom=8'h1A;
  11'h691:boot_rom=8'h02;
  11'h692:boot_rom=8'h38;
  11'h693:boot_rom=8'h4D;
  11'h694:boot_rom=8'h21;
  11'h695:boot_rom=8'h00;
  11'h696:boot_rom=8'hFE;
  11'h697:boot_rom=8'h7E;
  11'h698:boot_rom=8'hE6;
  11'h699:boot_rom=8'h07;
  11'h69A:boot_rom=8'h3D;
  11'h69B:boot_rom=8'h20;
  11'h69C:boot_rom=8'h44;
  11'h69D:boot_rom=8'h23;
  11'h69E:boot_rom=8'hAF;
  11'h69F:boot_rom=8'h32;
  11'h6A0:boot_rom=8'h0E;
  11'h6A1:boot_rom=8'hFE;
  11'h6A2:boot_rom=8'h01;
  11'h6A3:boot_rom=8'h0A;
  11'h6A4:boot_rom=8'h30;
  11'h6A5:boot_rom=8'hCD;
  11'h6A6:boot_rom=8'hCB;
  11'h6A7:boot_rom=8'h00;
  11'h6A8:boot_rom=8'h21;
  11'h6A9:boot_rom=8'hDE;
  11'h6AA:boot_rom=8'h00;
  11'h6AB:boot_rom=8'h01;
  11'h6AC:boot_rom=8'h28;
  11'h6AD:boot_rom=8'h30;
  11'h6AE:boot_rom=8'hCD;
  11'h6AF:boot_rom=8'hCB;
  11'h6B0:boot_rom=8'h00;
  11'h6B1:boot_rom=8'h2A;
  11'h6B2:boot_rom=8'h16;
  11'h6B3:boot_rom=8'hFE;
  11'h6B4:boot_rom=8'hE5;
  11'h6B5:boot_rom=8'hED;
  11'h6B6:boot_rom=8'h4B;
  11'h6B7:boot_rom=8'h12;
  11'h6B8:boot_rom=8'hFE;
  11'h6B9:boot_rom=8'h2A;
  11'h6BA:boot_rom=8'h14;
  11'h6BB:boot_rom=8'hFE;
  11'h6BC:boot_rom=8'hED;
  11'h6BD:boot_rom=8'h5B;
  11'h6BE:boot_rom=8'h1E;
  11'h6BF:boot_rom=8'hFE;
  11'h6C0:boot_rom=8'h79;
  11'h6C1:boot_rom=8'hA1;
  11'h6C2:boot_rom=8'h78;
  11'h6C3:boot_rom=8'h28;
  11'h6C4:boot_rom=8'h01;
  11'h6C5:boot_rom=8'h3C;
  11'h6C6:boot_rom=8'hCD;
  11'h6C7:boot_rom=8'h1A;
  11'h6C8:boot_rom=8'h02;
  11'h6C9:boot_rom=8'h38;
  11'h6CA:boot_rom=8'h16;
  11'h6CB:boot_rom=8'hCD;
  11'h6CC:boot_rom=8'hB3;
  11'h6CD:boot_rom=8'h00;
  11'h6CE:boot_rom=8'h3E;
  11'h6CF:boot_rom=8'hC9;
  11'h6D0:boot_rom=8'h32;
  11'h6D1:boot_rom=8'hF2;
  11'h6D2:boot_rom=8'hFF;
  11'h6D3:boot_rom=8'h21;
  11'h6D4:boot_rom=8'hD3;
  11'h6D5:boot_rom=8'h00;
  11'h6D6:boot_rom=8'h22;
  11'h6D7:boot_rom=8'hF0;
  11'h6D8:boot_rom=8'hFF;
  11'h6D9:boot_rom=8'h2A;
  11'h6DA:boot_rom=8'h16;
  11'h6DB:boot_rom=8'hFE;
  11'h6DC:boot_rom=8'h3E;
  11'h6DD:boot_rom=8'h1E;
  11'h6DE:boot_rom=8'hC3;
  11'h6DF:boot_rom=8'hF0;
  11'h6E0:boot_rom=8'hFF;
  11'h6E1:boot_rom=8'h21;
  11'h6E2:boot_rom=8'hE8;
  11'h6E3:boot_rom=8'h00;
  11'h6E4:boot_rom=8'h01;
  11'h6E5:boot_rom=8'h28;
  11'h6E6:boot_rom=8'h30;
  11'h6E7:boot_rom=8'hCD;
  11'h6E8:boot_rom=8'hCB;
  11'h6E9:boot_rom=8'h00;
  11'h6EA:boot_rom=8'h18;
  11'h6EB:boot_rom=8'hFE;
  11'h6EC:boot_rom=8'h01;
  11'h6ED:boot_rom=8'h03;
  11'h6EE:boot_rom=8'h1A;
  11'h6EF:boot_rom=8'h3E;
  11'h6F0:boot_rom=8'h82;
  11'h6F1:boot_rom=8'hED;
  11'h6F2:boot_rom=8'h79;
  11'h6F3:boot_rom=8'h0D;
  11'h6F4:boot_rom=8'h7E;
  11'h6F5:boot_rom=8'h23;
  11'h6F6:boot_rom=8'hED;
  11'h6F7:boot_rom=8'h79;
  11'h6F8:boot_rom=8'h01;
  11'h6F9:boot_rom=8'h00;
  11'h6FA:boot_rom=8'h18;
  11'h6FB:boot_rom=8'hAF;
  11'h6FC:boot_rom=8'hED;
  11'h6FD:boot_rom=8'h79;
  11'h6FE:boot_rom=8'h0C;
  11'h6FF:boot_rom=8'h5E;
  11'h700:boot_rom=8'hED;
  11'h701:boot_rom=8'h59;
  11'h702:boot_rom=8'h23;
  11'h703:boot_rom=8'h0D;
  11'h704:boot_rom=8'h3C;
  11'h705:boot_rom=8'hFE;
  11'h706:boot_rom=8'h0E;
  11'h707:boot_rom=8'h38;
  11'h708:boot_rom=8'hF3;
  11'h709:boot_rom=8'hC9;
  11'h70A:boot_rom=8'h70;
  11'h70B:boot_rom=8'h37;
  11'h70C:boot_rom=8'h28;
  11'h70D:boot_rom=8'h2D;
  11'h70E:boot_rom=8'h34;
  11'h70F:boot_rom=8'h1F;
  11'h710:boot_rom=8'h02;
  11'h711:boot_rom=8'h19;
  11'h712:boot_rom=8'h1C;
  11'h713:boot_rom=8'h00;
  11'h714:boot_rom=8'h07;
  11'h715:boot_rom=8'h00;
  11'h716:boot_rom=8'h00;
  11'h717:boot_rom=8'h00;
  11'h718:boot_rom=8'h00;
  11'h719:boot_rom=8'hC5;
  11'h71A:boot_rom=8'hD5;
  11'h71B:boot_rom=8'h01;
  11'h71C:boot_rom=8'h00;
  11'h71D:boot_rom=8'h30;
  11'h71E:boot_rom=8'h11;
  11'h71F:boot_rom=8'h07;
  11'h720:boot_rom=8'h20;
  11'h721:boot_rom=8'hED;
  11'h722:boot_rom=8'h51;
  11'h723:boot_rom=8'hCB;
  11'h724:boot_rom=8'hA0;
  11'h725:boot_rom=8'hED;
  11'h726:boot_rom=8'h59;
  11'h727:boot_rom=8'hCB;
  11'h728:boot_rom=8'hE0;
  11'h729:boot_rom=8'h03;
  11'h72A:boot_rom=8'hCB;
  11'h72B:boot_rom=8'h58;
  11'h72C:boot_rom=8'h28;
  11'h72D:boot_rom=8'hF3;
  11'h72E:boot_rom=8'hD1;
  11'h72F:boot_rom=8'hC1;
  11'h730:boot_rom=8'hC9;
  11'h731:boot_rom=8'h7E;
  11'h732:boot_rom=8'h23;
  11'h733:boot_rom=8'hB7;
  11'h734:boot_rom=8'hC8;
  11'h735:boot_rom=8'hED;
  11'h736:boot_rom=8'h79;
  11'h737:boot_rom=8'h03;
  11'h738:boot_rom=8'h18;
  11'h739:boot_rom=8'hF7;
  11'h73A:boot_rom=8'h4E;
  11'h73B:boot_rom=8'h49;
  11'h73C:boot_rom=8'h53;
  11'h73D:boot_rom=8'h45;
  11'h73E:boot_rom=8'h2D;
  11'h73F:boot_rom=8'h49;
  11'h740:boot_rom=8'h50;
  11'h741:boot_rom=8'h4C;
  11'h742:boot_rom=8'h20;
  11'h743:boot_rom=8'h00;
  11'h744:boot_rom=8'h4C;
  11'h745:boot_rom=8'h4F;
  11'h746:boot_rom=8'h41;
  11'h747:boot_rom=8'h44;
  11'h748:boot_rom=8'h49;
  11'h749:boot_rom=8'h4E;
  11'h74A:boot_rom=8'h47;
  11'h74B:boot_rom=8'h20;
  11'h74C:boot_rom=8'h20;
  11'h74D:boot_rom=8'h00;
  11'h74E:boot_rom=8'h45;
  11'h74F:boot_rom=8'h52;
  11'h750:boot_rom=8'h52;
  11'h751:boot_rom=8'h4F;
  11'h752:boot_rom=8'h52;
  11'h753:boot_rom=8'h00;
  11'h754:boot_rom=8'hF5;
  11'h755:boot_rom=8'hD5;
  11'h756:boot_rom=8'hCD;
  11'h757:boot_rom=8'h9A;
  11'h758:boot_rom=8'h02;
  11'h759:boot_rom=8'h38;
  11'h75A:boot_rom=8'h54;
  11'h75B:boot_rom=8'h3E;
  11'h75C:boot_rom=8'h02;
  11'h75D:boot_rom=8'hCD;
  11'h75E:boot_rom=8'h86;
  11'h75F:boot_rom=8'h02;
  11'h760:boot_rom=8'hD1;
  11'h761:boot_rom=8'hF1;
  11'h762:boot_rom=8'hF5;
  11'h763:boot_rom=8'hD5;
  11'h764:boot_rom=8'h7B;
  11'h765:boot_rom=8'h07;
  11'h766:boot_rom=8'hCB;
  11'h767:boot_rom=8'h12;
  11'h768:boot_rom=8'h07;
  11'h769:boot_rom=8'hCB;
  11'h76A:boot_rom=8'h12;
  11'h76B:boot_rom=8'h07;
  11'h76C:boot_rom=8'hCB;
  11'h76D:boot_rom=8'h12;
  11'h76E:boot_rom=8'h07;
  11'h76F:boot_rom=8'h3A;
  11'h770:boot_rom=8'h87;
  11'h771:boot_rom=8'hFF;
  11'h772:boot_rom=8'hCB;
  11'h773:boot_rom=8'hA7;
  11'h774:boot_rom=8'h30;
  11'h775:boot_rom=8'h02;
  11'h776:boot_rom=8'hF6;
  11'h777:boot_rom=8'h10;
  11'h778:boot_rom=8'h32;
  11'h779:boot_rom=8'h87;
  11'h77A:boot_rom=8'hFF;
  11'h77B:boot_rom=8'h7B;
  11'h77C:boot_rom=8'hE6;
  11'h77D:boot_rom=8'h0F;
  11'h77E:boot_rom=8'h3C;
  11'h77F:boot_rom=8'h5F;
  11'h780:boot_rom=8'hCD;
  11'h781:boot_rom=8'h7C;
  11'h782:boot_rom=8'h02;
  11'h783:boot_rom=8'hCD;
  11'h784:boot_rom=8'h9A;
  11'h785:boot_rom=8'h02;
  11'h786:boot_rom=8'h38;
  11'h787:boot_rom=8'h27;
  11'h788:boot_rom=8'h3E;
  11'h789:boot_rom=8'h80;
  11'h78A:boot_rom=8'hCD;
  11'h78B:boot_rom=8'h8F;
  11'h78C:boot_rom=8'h02;
  11'h78D:boot_rom=8'h01;
  11'h78E:boot_rom=8'hFB;
  11'h78F:boot_rom=8'h0F;
  11'h790:boot_rom=8'h78;
  11'h791:boot_rom=8'hDB;
  11'h792:boot_rom=8'hF8;
  11'h793:boot_rom=8'h0F;
  11'h794:boot_rom=8'h30;
  11'h795:boot_rom=8'h09;
  11'h796:boot_rom=8'h0F;
  11'h797:boot_rom=8'h30;
  11'h798:boot_rom=8'hF7;
  11'h799:boot_rom=8'hED;
  11'h79A:boot_rom=8'h78;
  11'h79B:boot_rom=8'h77;
  11'h79C:boot_rom=8'h23;
  11'h79D:boot_rom=8'h18;
  11'h79E:boot_rom=8'hF1;
  11'h79F:boot_rom=8'h07;
  11'h7A0:boot_rom=8'hE6;
  11'h7A1:boot_rom=8'h1E;
  11'h7A2:boot_rom=8'h20;
  11'h7A3:boot_rom=8'h0B;
  11'h7A4:boot_rom=8'hD1;
  11'h7A5:boot_rom=8'hF1;
  11'h7A6:boot_rom=8'h13;
  11'h7A7:boot_rom=8'h3D;
  11'h7A8:boot_rom=8'h20;
  11'h7A9:boot_rom=8'hB8;
  11'h7AA:boot_rom=8'hCD;
  11'h7AB:boot_rom=8'hB3;
  11'h7AC:boot_rom=8'h02;
  11'h7AD:boot_rom=8'hAF;
  11'h7AE:boot_rom=8'hC9;
  11'h7AF:boot_rom=8'hD1;
  11'h7B0:boot_rom=8'hF1;
  11'h7B1:boot_rom=8'hCD;
  11'h7B2:boot_rom=8'hB3;
  11'h7B3:boot_rom=8'h02;
  11'h7B4:boot_rom=8'h37;
  11'h7B5:boot_rom=8'hC9;
  11'h7B6:boot_rom=8'h01;
  11'h7B7:boot_rom=8'hFA;
  11'h7B8:boot_rom=8'h0F;
  11'h7B9:boot_rom=8'hED;
  11'h7BA:boot_rom=8'h59;
  11'h7BB:boot_rom=8'h0C;
  11'h7BC:boot_rom=8'hED;
  11'h7BD:boot_rom=8'h51;
  11'h7BE:boot_rom=8'h3E;
  11'h7BF:boot_rom=8'h1E;
  11'h7C0:boot_rom=8'hCD;
  11'h7C1:boot_rom=8'h8F;
  11'h7C2:boot_rom=8'h02;
  11'h7C3:boot_rom=8'hED;
  11'h7C4:boot_rom=8'h78;
  11'h7C5:boot_rom=8'h0F;
  11'h7C6:boot_rom=8'h38;
  11'h7C7:boot_rom=8'hFB;
  11'h7C8:boot_rom=8'hC9;
  11'h7C9:boot_rom=8'h01;
  11'h7CA:boot_rom=8'hF8;
  11'h7CB:boot_rom=8'h0F;
  11'h7CC:boot_rom=8'hED;
  11'h7CD:boot_rom=8'h79;
  11'h7CE:boot_rom=8'h3E;
  11'h7CF:boot_rom=8'h10;
  11'h7D0:boot_rom=8'h3D;
  11'h7D1:boot_rom=8'h20;
  11'h7D2:boot_rom=8'hFD;
  11'h7D3:boot_rom=8'hC9;
  11'h7D4:boot_rom=8'h1E;
  11'h7D5:boot_rom=8'h80;
  11'h7D6:boot_rom=8'hCD;
  11'h7D7:boot_rom=8'hB5;
  11'h7D8:boot_rom=8'h02;
  11'h7D9:boot_rom=8'h06;
  11'h7DA:boot_rom=8'h03;
  11'h7DB:boot_rom=8'h11;
  11'h7DC:boot_rom=8'h00;
  11'h7DD:boot_rom=8'h00;
  11'h7DE:boot_rom=8'h3E;
  11'h7DF:boot_rom=8'h0F;
  11'h7E0:boot_rom=8'hDB;
  11'h7E1:boot_rom=8'hF8;
  11'h7E2:boot_rom=8'h07;
  11'h7E3:boot_rom=8'hD0;
  11'h7E4:boot_rom=8'h1B;
  11'h7E5:boot_rom=8'h7A;
  11'h7E6:boot_rom=8'hB3;
  11'h7E7:boot_rom=8'h20;
  11'h7E8:boot_rom=8'hF5;
  11'h7E9:boot_rom=8'h10;
  11'h7EA:boot_rom=8'hF3;
  11'h7EB:boot_rom=8'h37;
  11'h7EC:boot_rom=8'hC9;
  11'h7ED:boot_rom=8'h1E;
  11'h7EE:boot_rom=8'h00;
  11'h7EF:boot_rom=8'h3A;
  11'h7F0:boot_rom=8'h87;
  11'h7F1:boot_rom=8'hFF;
  11'h7F2:boot_rom=8'hE6;
  11'h7F3:boot_rom=8'h1F;
  11'h7F4:boot_rom=8'hB3;
  11'h7F5:boot_rom=8'h01;
  11'h7F6:boot_rom=8'hFC;
  11'h7F7:boot_rom=8'h0F;
  11'h7F8:boot_rom=8'hED;
  11'h7F9:boot_rom=8'h79;
  11'h7FA:boot_rom=8'hC9;
  11'h7FB:boot_rom=8'hFF;
  11'h7FC:boot_rom=8'hFF;
  11'h7FD:boot_rom=8'hFF;
  11'h7FE:boot_rom=8'hFF;
  11'h7FF:boot_rom=8'hFF;
endcase
end
endfunction
/////
reg [7:0] DO;
always @(posedge CLK) DO <= boot_rom(A);

endmodule

