/****************************************************************************
	Binary to verilogHDL converter

	Copyright(c) 2004,2005 T&A Tatsuyuki Satoh

	note:

	use MinGW32

	Histry
	2004.11.15 Ver.1.00 Created
****************************************************************************/

#include <windows.h>
#include <stdio.h>

/* ---------- File Buffer ----------- */
#define MAX_FILE_SIZE 65536*4

BYTE file_buffer[MAX_FILE_SIZE];

char filename[256];
char filename_w[256];
char arrayname[256];

/***************************************************************************/
/* MAIN                                                                    */
/***************************************************************************/
int main(int argc,char *argv[])
{
	FILE *hndl = NULL;
	FILE *hndl_w;
	DWORD file_size;
	int err = 0;
	int i , j;
	int output_size;

	int adr_depth;
	int data_width;
	int byte_per_data;
	int byte_per_step;
	int start_pos , end_addr;
	int use_default;
	int pad_code;

	// ^Cg\
	printf("\n\
Binary to VerilogHDL file converter Ver.1.10\n\
Copyrght(c) 2004,2005 T&A Tatsuuki Satoh\n");

	filename[0] = 0;
	filename_w[0] = 0;
	arrayname[0] = 0;
	output_size = MAX_FILE_SIZE;

	data_width = 8;
	start_pos = 0;
	byte_per_step = 0;
	use_default = 0;
	pad_code = 0;

	for( i=1 ; i<argc ; i++ )
	{
		if( argv[i][0] == '/' || argv[i][0] == '-')
		{
			// IvVXCb`
			switch( argv[i][1]|0x20 )
			{
			case 'n': sscanf(&(argv[i][2]),"%s",arrayname); break;
			case 's': sscanf(&(argv[i][2]),"%d",&output_size); break;
			case 'a': sscanf(&(argv[i][2]),"%x",&start_pos); break;
			case 'w': sscanf(&(argv[i][2]),"%d",&data_width); break;
			case 'o': sscanf(&(argv[i][2]),"%d",&byte_per_step);  break;
			case 'p': sscanf(&(argv[i][2]),"%x",&pad_code);  break;
			case 'd': use_default = 1; break;

			}
		}
		else
		{
			// t@C
			if(!filename[0])
				sprintf(filename,"%s",argv[i]);
			else if(!filename_w[0])
				sprintf(filename_w,"%s",argv[i]);
			else
				err = 1;
		}
	}
	if(!filename[0] || !filename_w[0])
		err = 1;

	// 
	if(err)
	{
		printf("\n\
useage: bin2ver [options] src_file dist_file\n\
  options :\n\
       -n[name]  : output data name\n\
       -a        : start address\n\
       -s        : max file size\n\
       -w[width] : data width\n\
       -p[code]  : set PAD code\n\
       -d        : use default for PAD data\n\
       -o        : number of bytes per data\n\
");
		exit(1);
	}

	//̓t@C.bingqǉ
	if(!strstr(filename,"."))
		strcat(filename,".bin");

	//o̓t@C.vgqǉ
	if(!strstr(filename_w,"."))
		strcat(filename_w,".v");

	//ϐȂΓ̓t@CRs[
	if(arrayname[0]==0)
	{
		char *top,*next;

		// t@Ĉ݃Rs[
		next = filename;
		do
		{
			top = next;
			next = strpbrk(next,"\\/");
		}while(next++);
		strcpy(arrayname,top);

		// ֑L̒u
		while((top=strpbrk(arrayname,".(),-+*"))!=NULL)
			*top = '_';
	}

	// BINt@C̃I[v
	hndl = fopen(filename,"rb");
	if( hndl == NULL )
	{
		printf("Can't open binary file '%s'\n",filename);
		return 1;
	}

	// vt@CI[v
	hndl_w = fopen(filename_w,"wt");
	if(hndl_w==NULL)
	{
		printf("Can't create VerilogHDL file '%s'\n",filename_w);
		fclose(hndl);
		return 1;
	}

	// oCg
	byte_per_data = (data_width+7)/8;
	if(byte_per_step==0)
		byte_per_step = byte_per_data;

	// PADŖ߂
	for(i=0;i<MAX_FILE_SIZE;i+=byte_per_step)
	{
		for(j=0;j<byte_per_step;j++)
			file_buffer[i+j] = pad_code>>(8*j);
	}

	// t@C[h
	file_size = fread(file_buffer,1,output_size,hndl);
#if 1
	if(output_size == MAX_FILE_SIZE)
		output_size = file_size;
#endif
	// AhX̃rbgvZ
	for(adr_depth=0;(byte_per_step<<adr_depth)<output_size;adr_depth++);

	printf("filesize = %ld,%dbit\n",file_size,adr_depth);

	// 萔z
	fprintf(hndl_w,"function [%d:0] %s ;\n", data_width-1,arrayname);
	fprintf(hndl_w,"input [%d:0] addr;\n",adr_depth-1);
	fprintf(hndl_w,"begin\n");
	fprintf(hndl_w,"case(addr)\n");

	end_addr = (byte_per_step<<adr_depth) - byte_per_step +1;

	for(i=0;i<end_addr;i+=byte_per_step)
	{
		int word_data = 0;

		for(j=0;j<byte_per_data;j++)
			 word_data =  word_data | (file_buffer[i+j+start_pos]<<(8*j));

		if(use_default && word_data==pad_code)
		{
			use_default++;
		}
		else
		{
			fprintf(hndl_w,"  %d'h%X:%s=%d'h%02X;\n",adr_depth,i/byte_per_step,arrayname,data_width,word_data);
		}
	}

	// "default"o
	if(use_default > 0)
	{
		fprintf(hndl_w,"  default:%s=%d'h%02X;\n",arrayname,data_width,pad_code);
	}
	fprintf(hndl_w,"endcase\n");
	fprintf(hndl_w,"end\n");
	fprintf(hndl_w,"endfunction\n");

	fclose(hndl);
	fclose(hndl_w);

	if(err)
		return 1;

	printf("complete\n");
	return 0;
}

